package ch.swisslife.ibgm.mc2;
import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

/** Dialog for saving files. Extends ChooseDialog class. 
 * It reads the directory contents from cgi DirectoryReader.
 *
 * @author 	Michael Grob for RA/SL
 * @version 	1.01 09/04/98
 */
public class SaveDialog extends ChooseDialog {


	private boolean open; //if true, button 1 is labeled "open"
	private Label path_label;

	/** Constructor with some arguments.
	 *
	 * @param address	String with address of cgi
	 * @param base		String with address of the cfg base
	 * @param file_name	String with name of the cfg
	 * @param title		String with title of the dialog
	 * @param button_1	String: Name of button1
	 * @param button_2	String: Name of button2
	 * @param label_1	String: Name of label1
	 * @param explanation	String: name of explanation label
	 */
	public SaveDialog(String address, String base, String file_name, String title, String button_1, String button_2, String label_1, String explanation) {
		this.super(address, base, title, button_1, button_2, "Current Folder:", label_1, explanation);
		this.directory_list.addActionListener(new openDirectory());

		field.requestFocus();
		field.setText(file_name);
	}


	//procedures for overwrite						
	
	/* This was intended to enhance the user interface, but it didn't work well. Therefore it is commented out.


		
	public boolean getOpen() {

		if (open) {
			openFile(directory_list.getSelectedItem());
			return false;
		}
		else {
			return true;
		}
	}
	*/

	public void listSelected(String s) {
		}


	/* Was intended to enhance the user interface (button switch to 'Open' if the user clicked into the list.
	   Removed because the user had to click into the name field to get the 'Save" Button back.

	public void setDirectoryFocus(boolean b) {
		open = b;
		if (b) {
			button1.setLabel("Open");
			}
		else{
			button1.setLabel("Save");
		}
	}					
	
	*/


	/** Opens a directory and shows its content or sends the message to open a file.
	 *
	 * @param s	String with item clicked on 
	 */
	private void openFile (String s) {
		String h = "/";
		s = s.trim();
		if (s.equals("..")) {
			cfg_base = removeLastWord(cfg_base, "/");
			GetDirectoryContents(cfg_base);
		}
		else {	
			if (s.charAt(s.length() -1) == h.toCharArray()[0]) {
				// we got a directory
				cfg_base = cfg_base + s;
				GetDirectoryContents(cfg_base);
			}
		}
		path.setText(cfg_base);
	}

	/* Checks if path is ok and tells MC2 to save it.
	 */ 
	
	public String getURL() {
		cfg_base = cfg_base.trim();
		return cfg_base+field.getText();
	}


	// Overwrites a method of ChooseDialog

	/** puts the content of a directory into the list.
	 */	
	
	protected void ShowContentsOfDirectory() {
		String Line;
		int Index = 1;
		try{
			directory_list.removeAll();
			Line = dataInput.readLine();
			directory_list.addItem("..",0);

			while((Line != null)&&(Line.length() != 0)) {
				Line = Line.trim();
				directory_list.addItem(Line,Index);
				Line = dataInput.readLine();
				Index++;
			}
			dataInput.close();
			directory_list.select(1);
			field.requestFocus();
		}

		catch(IOException e){	
			String Message = "IOException while reading Error-Messages from DirectoryReader:\n" + e +"\n"
					+ "Maybe you don't have access privileges?";
			AWTHelper.warn(Message);
		}	
	}


	/*Overwrite from ChooseDialog*/
	protected void GetDirectoryContents(String Directory) {
		URL DirectoryReaderURL = null;
		String URLWithQueryString = AddressOfDirectoryReader + "?BASE=" + Directory;
		try {	
			DirectoryReaderURL = new URL(URLWithQueryString);
		}
	
	
		catch(MalformedURLException e) {
		
		  	String Message = "MalformedURLException occured in'GetDirectoryContents.\n"
		  		+"Maybe syntax error in URL: " 
		  		+ Directory + "\n";
			AWTHelper.warn(Message);
		}		
		try{
			URLConnection Connection = DirectoryReaderURL.openConnection();
			dataInput = new BufferedReader(new InputStreamReader( Connection.getInputStream()));
			ShowContentsOfDirectory();
		}
		catch(IOException e){
			String Message = "IO Exception occured, " + e + "\n";
			AWTHelper.warn(Message);
			cfg_base = removeLastWord(cfg_base, "/");
			path.setText(cfg_base);
		}
	}


	// Inner class for handling the list

	class openDirectory implements ActionListener {

		public void actionPerformed(ActionEvent e) {

			openFile(directory_list.getSelectedItem());
		}
	}
}
