package ch.swisslife.ibgm.mc2;
import java.net.*;
import java.io.*;
import java.awt.*;

/** Dialog for opening files. Extends ChooseDialog class. 
 * It reads the directory contents form cgi DirectoryReader.
 * @author 	Michael Grob for RA/SL
 * @version 	1.01 09/04/98
 */
public class OpenDialog extends ChooseDialog {

	/** Constructor with some arguments.
	 *
	 * @param address	String with address of cgi
	 * @param base		String with address of the cfg base
	 * @param title		String with title of the dialog
	 * @param parent	MyMessage: the parent class
	 * @param button_1	String: Name of button1
	 * @param button_2	String: Name of button2
	 * @param label_1	String: Name of label1
	 * @param lablel_2	String: Name of label2
	 * @param explanation	String: name of explanation label
	 */
	public OpenDialog(String address, String base, String title, String button_1, String button_2, String label_1, String label_2, String explanation) {
		this.super(address, base, title, button_1, button_2, label_1, label_2, explanation);
	
		field.setText("public@hostname");
	}


	//procedures for overwrite						
	
	public void listSelected(String s) {
			cfg_base = removeLastWord(cfg_base, "/");
			cfg_base += s;
			cfg_base = cfg_base.trim();
			path.setText(cfg_base);
	}


	/** Opens a directory and shows its content or sends the message to open a file.
	 *
	 * @param s	String with item clicked on 
	 */
	public boolean getOpen () {
		// usual trick for getting a char from a string
		String h = "/";
		String s = directory_list.getSelectedItem();
		s = s.trim();

		if (field.getText().equals("public@hostname")) {
			if (s.equals("..")) {
				cfg_base = removeLastWord(cfg_base, "/");
				cfg_base = removeLastWord(cfg_base, "/");
				GetDirectoryContents(cfg_base);
				path.setText(cfg_base);
				return false;
			}
			else {	
				if (s.charAt(s.length() -1) == h.toCharArray()[0]) {
					// we got a directory
					GetDirectoryContents(cfg_base);
					path.setText(cfg_base);
					return false;
				}
			}
		}
		else {
			return true;
		}
		// should never go there
		return true;
	}


	public String getURL() {
		if (field.getText().equals("public@hostname")) {
			return cfg_base;

		}
		else {
			return field.getText();
		}
	}


	public String getDevice() {
		if (field.getText().equals("public@hostname")) {
			return "FILE";
		}
		else {
			return "DEVICE";
		}
	}
}
