package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.awt.event.*;
import java.util.StringTokenizer;

/** User Interface and test routines for <code>InputChannel</code>
 * Puts a frame on screen and perfoms calls to <code>InputChannel</code> and prints
 * it back on the screen.
 * Note: This class is experimantal!
 *
 * @author	Michael Grob for RA/SL
 * @version	1.01 /09/04/98
 */
public class MC2 extends Frame {
	
	// GUI Components

	protected Button get_cfg, save_cfg;
	protected Button edit_target, create_target, delete_target, check_port, copy_target;
	Label message;			// status field
	Label list_title;
	Panel p;
	List target_list;
	MC2 mc2;
	CheckPort checkport;

	// Components for the Cfg-specific entries

	TextField work_field;
	TextField icon_field;
	TextField interval_field;
	TextField refresh_field;

	Label work_label;
	Label icon_label;
	Label interval_label;
	Label refresh_label;
	Panel field_panel;


	// THE data structure
	
	Cfg file = new Cfg();
		
	private String url;
	private boolean cfg_loaded = false;	// is there already a cfg?
	protected int current;			// which target is selected?
	private MC2Applet MyApplet;		// Applet Object that called MC2

	private ChooseDialog open_dialog, add_dialog, save_dialog, line_dialog;
	private YesNoDialog close_dialog, delete_dialog;

	// the layout manager
	GridBagLayout gridbag = new GridBagLayout();
	
	
	/** Constructor: only used for instatiating CheckPort
	 *
	 * @param title		String with window title
	 * @param m		MC2 object that called me
	 */
	public MC2 (String title) {
		super(title); 		// makes a frame
	}


	/** Constructor: sets up the window
	 *
	 * @param title		String with window title
	 * @param applet	MC2Applet that called me
	 */
	public MC2 (String title, MC2Applet applet) {
		super(title); 		// makes a frame
		MyApplet = applet;
		mc2 = this;

		// create the buttons
		get_cfg = new Button("Get Cfg...");
		save_cfg = new Button("Save Cfg...");
		edit_target = new Button("Edit Target...");
		create_target = new Button("Import Target...");
		delete_target = new Button("Delete Target...");
		check_port = new Button("Check Port...");
		copy_target = new Button("Copy Target");

		// create the message label
		message = new Label("Please get a Cfg.                      ");
		
		// create a list with 15 lines
		Font f = new Font("Courier",Font.PLAIN, 12);
		target_list = new List(15);
		target_list.setFont(f);

		target_list.addItem("No Target selected.", 0);
		list_title = new Label("Target Name       Address       Interface      IP                                                      Port    ");

		list_title.setFont(f);

		// create the panel
		// use gridbag for it
		p = new Panel(); 
		p.setLayout(gridbag);

		// Entry Components

		field_panel = new Panel();
		field_panel.setLayout(gridbag);
		work_field = new TextField(40);
		work_field.setBackground(Color.white);
		icon_field = new TextField(40);
		icon_field.setBackground(Color.white);
		interval_field = new TextField(6);
		interval_field.setBackground(Color.white);
		refresh_field = new TextField(6);
		refresh_field.setBackground(Color.white);
		this.setBackground(Color.lightGray);


		work_label = new Label("WorkDir:");
		icon_label = new Label("IconDir:");
		interval_label = new Label("Interval:");
		refresh_label = new Label("Refresh:");

		AWTHelper.constrain(field_panel, work_label, 0,0,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,10);
		AWTHelper.constrain(field_panel, icon_label, 0,1,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,10);
		AWTHelper.constrain(field_panel, work_field, 1,0,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,10);
		AWTHelper.constrain(field_panel, icon_field, 1,1,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,10);
		AWTHelper.constrain(field_panel, interval_label, 2,0,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,10);
		AWTHelper.constrain(field_panel, refresh_label, 2,1,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,10);
		AWTHelper.constrain(field_panel, interval_field, 3,0,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(field_panel, refresh_field, 3,1,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
				
		// use constrain() to add components to panel
		AWTHelper.constrain(p, field_panel, 0,0,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,10,0);
		AWTHelper.constrain(p, list_title, 0,1,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,10);
		AWTHelper.constrain(p, target_list, 0,2,1,8, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0,1.0,0,0,0,10);

		AWTHelper.constrain(p, get_cfg, 1,2,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, save_cfg, 1,3,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, edit_target, 1,4,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, create_target, 1,5,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, copy_target, 1,6,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);

		AWTHelper.constrain(p, delete_target, 1,7,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, check_port, 1,8,1,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, message, 0,10,2,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);

		// use GridBagLayout to arrange the panels
		this.setLayout(gridbag); 
		// and put the into top level Windwow
		AWTHelper.constrain(this, p, 0,0,1,1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 1.0,1.0,10,10,10,10);


		// Attach the listeners to the objects

		get_cfg.addActionListener(new GetHandler());
		save_cfg.addActionListener(new SaveHandler());
		edit_target.addActionListener(new EditHandler());
		create_target.addActionListener(new CreateHandler());
		copy_target.addActionListener(new CopyHandler());
		delete_target.addActionListener(new DeleteHandler());
		check_port.addActionListener(new CheckHandler());
		target_list.addActionListener(new EditHandler());
		target_list.addItemListener(new ListSelectHandler());
		this.addWindowListener(new WindowHandler());

		// The handlers for the mouseEvents..

			this.get_cfg.addMouseListener(new showInfo("Get a new Cfg either from a file or a device."));
			this.save_cfg.addMouseListener(new showInfo("Save the current Cfg to a file."));
			this.edit_target.addMouseListener(new showInfo("Edit the selected Target."));
			this.create_target.addMouseListener(new showInfo("Import targets from a device or another Cfg into this Cfg."));
			this.copy_target.addMouseListener(new showInfo("Copy a target"));
			this.delete_target.addMouseListener(new showInfo("Delete the selected target from the Cfg."));
			this.check_port.addMouseListener(new showInfo("Check if the port number is correct."));
			this.target_list.addMouseListener(new showInfo("This is the List with the targets of the current Cfg."));
			this.work_field.addMouseListener(new showInfo("Path to the WorkDir of this Cfg."));
			this.icon_field.addMouseListener(new showInfo("Path to the IconDir of mrtg."));
			this.interval_field.addMouseListener(new showInfo("Time between 2 mrtg pollings"));
			this.refresh_field.addMouseListener(new showInfo("Time until browser has to relaod the HTML page."));
	}
		
		
	/** Main: Only used for Testing. Instantiates itself.
	 * Note: This shouldn't be used in the final version
	 * @param args	String[] argument vector
	 */
	public static void main(String[] args) {
	// can only be called from the applet
	}


	/** Instantiates an OutputChannel and starts the printing.
	 */
	public void saveToFile() {
	
		String filename ="";
		// Put the text fields into the Cfg

		file.setValue("WorkDir", work_field.getText());
		file.setValue("IconDir", icon_field.getText());
		file.setValue("Interval", interval_field.getText());
		file.setValue("Refresh", refresh_field.getText());

		String URL =MyApplet.getMyParameter("cfgBase");
		if (file.getValue("Url").equals("")) {
			filename = file.getValue(0, "Address") + ".cfg";
		}
		else {
			URL = file.getValue("Url");
			StringTokenizer ST = new StringTokenizer(URL, "/");

			URL = "";
			// give me the last Token which is the community and hostname
			while(ST.hasMoreTokens()) {
				URL += filename + "/";
				filename = ST.nextToken();
			}
			
			// Just the address, not "public@"
			StringTokenizer ST2 = new StringTokenizer(filename, "@");

			// give me the last Token which is the community and hostname
			while(ST2.hasMoreTokens()) {
				filename = ST2.nextToken();
			}
		}

		String DirectoryReader = MyApplet.getMyParameter("DirectoryReader");
		save_dialog = new SaveDialog(DirectoryReader, URL, filename, "Save Dialog", "Save", "Cancel", "File", "Please choose a location to save the file.");
		save_dialog.button1.addActionListener(new Save1());
		save_dialog.button2.addActionListener(new ChooseCancel(save_dialog));
		//save_dialog.directory_list.addActionListener(new Save1());
		save_dialog.addWindowListener(new ChooseWindow(save_dialog));
	}


	/**Opens an editor window and puts the data in
	 */
	public void editIt() {

		if (!cfg_loaded) {
			AWTHelper.warn("Please load a Cfg first.");				
		}
		else {
			EditTarget ET = new EditTarget(file, current, this);
			ET.pack(); // bug workaround
			ET.show();
		}
	
	}


	/**"Saves" the changes in a Cfg structure.
	 *
	 * @param new_file	Cfg with new structure
	 */
	public void saveCfg(Cfg new_file) {
		this.file = new_file;
		putIntoList();
	}


	/** puts the targets of the Cfg file into the list.
	*/
	protected void putIntoList(){
		String s;
		String Space = "                                                                                                                  ";
		
		target_list.removeAll();

		// put values into the text fields

		work_field.setText( file.getValue("WorkDir"));
		icon_field.setText(file.getValue("IconDir"));
		interval_field.setText(file.getValue("Interval"));
		refresh_field.setText(file.getValue("Refresh"));

		for(int i = 0; i<file.getNumberOfTargets(); i++) 	{

			// put the line together
			String t = file.getValue(i, "Target");
			String a = file.getValue(i, "Address");
			String in = file.getValue(i, "Interface");
			String ip = file.getValue(i,"IP");
			String p = file.getValue(i, "Port");
	
			if (t.length() > 15) {
				s = t.substring(0,13) + ".. ";
			}
			else { 
				s = t+ Space.substring(0, 17 - t.length());
			}

			if (a.length() > 13) {
				s += a.substring(0,11) + ".. ";
			}
			else { 

				s += a + Space.substring(0, 15 - a.length());
			}

			if (in.length() > 12) {
				s += in.substring(0,10) + ".. ";
			}
			else { 
					s += in + Space.substring(0, 14 - in.length());
			}
			if (ip.length() > 50) {
				s += ip.substring(0,48) + ".. ";
			}
			else { 
				s += ip + Space.substring(0, 51 - ip.length());
			}
			if (p.length() > 4) {
				s += p.substring(0,2) + "..";
			}
			else { 
				s += Space.substring(0, 8 - p.length()) + p;
			}
			target_list.addItem(s);
		}
	}



	/** Puts a message into the messagefield
	 * 
	 * @param s	String with the message
	 */
	private void msg(String s) {
		message.setText(s);
	}

	//------------------------------- INNER CLASSES -------------------------------------------------------

	/** Inner class for handling the action event -- save_cfg button.
	 */
	class SaveHandler implements ActionListener {

		// write it back to CFG
		public void actionPerformed(ActionEvent e) {
			if (cfg_loaded) {
				saveToFile();	
			}
			else {
				AWTHelper.warn("Please load a Cfg first.");
			}	
		}
	}


	/** Inner class for handling the action event -- get_cfg button.
	 */
	class GetHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			String URL = MyApplet.getMyParameter("cfgBase");
			String DirectoryReader =  MyApplet.getMyParameter("DirectoryReader");
			open_dialog = new OpenDialog(DirectoryReader, URL, "Open Dialog", "Open", "Cancel", "File", "Device", "Please choose a Cfg file OR a device");
			open_dialog.button1.addActionListener(new Open1());
			open_dialog.button2.addActionListener(new ChooseCancel(open_dialog));
			open_dialog.directory_list.addActionListener(new Open1());
			open_dialog.addWindowListener(new ChooseWindow(open_dialog));
		}
	}


	/** Inner class for handling the action event -- edit_target button.
	 */
	class EditHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			editIt();
		}
	}


	/** Inner class for handling the action event -- create_target button.
	 */
	class CreateHandler implements ActionListener {

		public void actionPerformed(ActionEvent e){

			String URL = MyApplet.getMyParameter("cfgBase");
			String DirectoryReader =  MyApplet.getMyParameter("DirectoryReader");
			add_dialog = new OpenDialog(DirectoryReader, URL, "Open Dialog", "Open", "Cancel", "File", "Device", "Please choose a Cfg file OR a device for additional targets");
			add_dialog.button1.addActionListener(new Add1());
			add_dialog.button2.addActionListener(new ChooseCancel(add_dialog));
			add_dialog.directory_list.addActionListener(new Add1());
			add_dialog.addWindowListener(new ChooseWindow(add_dialog));
		}
	}


	/** Inner class for handling the action event -- copy_target button.
	 */
	class CopyHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {

			int c = current;
			try {
				Target t = new Target("test");
				Target t_old = (Target) file.Targets.elementAt(c);
				t = t_old.copy(t);
				current = file.addTarget(t);
				file.setValue(current, "Target", "Copy_of_"+file.getValue(++c, "Target"));
				putIntoList();
			}
			catch (java.lang.CloneNotSupportedException CNSE) {
				AWTHelper.warn("An Exception occured while cloning the target.");
			}
		}
	}



	/** Inner class for handling the action event -- delete_target button.
	 */
	class DeleteHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			if (cfg_loaded) {
				delete_dialog = new YesNoDialog(mc2, "Delete?", "Really delete this target?", "Yes", "No", "Cancel");
				delete_dialog.yes.addActionListener(new DeleteYes());
				delete_dialog.no.addActionListener(new YesNoCancel(delete_dialog));
				delete_dialog.cancel.addActionListener(new YesNoCancel(delete_dialog));
				delete_dialog.addWindowListener(new YesNoWindow(delete_dialog));
				delete_dialog.pack();
				delete_dialog.show();
			}
			else {
				AWTHelper.warn("Please load a Cfg first.");
			}	
		}
	}


	/** Inner class for handling the action event -- check_port button.
	 */
	class CheckHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			line_dialog = new LineDialog("Choose device", "Please choose the device to check the port numbers.", "public@" + file.getValue(current, "Address"));
			line_dialog.button1.addActionListener(new Check());
			line_dialog.button2.addActionListener(new ChooseCancel(line_dialog));
			line_dialog.addWindowListener(new ChooseWindow(line_dialog));
			line_dialog.pack();
			line_dialog.show();
		}
	}


	/** Inner class for handling the window close event.
	 */
	class WindowHandler extends WindowAdapter {

		public void windowClosing(WindowEvent e) {
			close_dialog = new YesNoDialog(mc2, "Save?", "Save your Changes?", "Save", "Don't save", "Cancel");
			close_dialog.yes.addActionListener(new CloseYes());
			close_dialog.no.addActionListener(new CloseNo());
			close_dialog.cancel.addActionListener(new YesNoCancel(close_dialog));
			close_dialog.addWindowListener(new YesNoWindow(close_dialog));
			close_dialog.pack();
			close_dialog.show();
		}
	}



	/** Inner class for handling the Item event event -- list_select.
	 */
	class ListSelectHandler implements ItemListener {

		public void itemStateChanged(ItemEvent e) {
			mc2.current = (target_list.getSelectedIndex());
		}
	}




//-------------------------------------- YES NO DIALOG --------------------------------

	/** Inner class for handling the action event of the YesNo dialog-- cancel button.
	 */
	class YesNoCancel implements ActionListener {

		YesNoDialog dialog;

		YesNoCancel(YesNoDialog d) {
		
			this.dialog = d;
		}

		public void actionPerformed(ActionEvent e) {
			dialog.kill();
		}
	}


	/** Inner class for handling the window close event.
	 */
	class YesNoWindow extends WindowAdapter {


		YesNoDialog dialog;

		YesNoWindow(YesNoDialog d) {
		
			this.dialog = d;

		}

		public void windowClosing(WindowEvent e) {
			dialog.kill();
		}
	}

// ------------------------------------------ close dialog ------------------------------

	/** Inner class for handling the action event of the yes no dialog-- yes button.
	 */
	class CloseYes implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			close_dialog.kill();
			saveToFile();
			mc2.setVisible(false);
			mc2.dispose();
		}
	}


	/** Inner class for handling the action event of the yes no dialog-- no button.
	 */
	class CloseNo implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			close_dialog.kill();
			mc2.setVisible(false);
			mc2.dispose();

		}
	}


// ------------------------------------------ delete dialog ------------------------------

	/** Inner class for handling the action event of the delete dialog-- yes button.
	 */
	class DeleteYes implements ActionListener {

		public void actionPerformed(ActionEvent e) {

			delete_dialog.kill();
			mc2.file.deleteTarget(current);
			putIntoList();

			}
	}


// ----------------------------------- CHOOSE DIALOG -----------------------------------



	/** Inner class for handling the action event of the choose dialog-- cancel button.
	 */
	class ChooseCancel implements ActionListener {

		ChooseDialog dialog;

		ChooseCancel(ChooseDialog d) {
		
			this.dialog = d;
		}
		public void actionPerformed(ActionEvent e) {
			dialog.kill();
		}
	}


	/** Inner class for handling the window close event on choose dialogs.
	 */
	class ChooseWindow extends WindowAdapter {

		ChooseDialog dialog;

		ChooseWindow(ChooseDialog d) {
		
			this.dialog = d;
		}
		public void windowClosing(WindowEvent e) {
			dialog.kill();
		}
	}


// ------------------------------------------ open dialog ------------------------------



	/** Inner class for handling the action event of the open dialog--  button 1.
	 */
	class Open1 implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			

			if (open_dialog.getOpen()) {

				open_dialog.kill();

				msg("Opening Input Channel, please wait...");
				InputChannel channel = new InputChannel(MyApplet.getMyParameter("cfgReader"), MyApplet.getMyParameter("WorkDir"), MyApplet.getMyParameter("IconDir"));
				String u = open_dialog.getURL();

				String d = open_dialog.getDevice();

				file = channel.getFromCgi(d, u);
				cfg_loaded = true;

				if (d.equals("DEVICE")) {
					file.setValue("Url", MyApplet.getMyParameter("cfgBase") + u + ".cfg");
				}
				else {
					file.setValue("Url", u);
				}
				msg("Cfg active: " + file.getValue("Url"));

				putIntoList();
			}
		}
	}


// ------------------------------------------ save dialog ------------------------------


	/** Inner class for handling the action event of the save dialog--  button 1.
	 */
	class Save1 implements ActionListener {

		public void actionPerformed(ActionEvent e) {

			//if (save_dialog.getOpen()) {

				save_dialog.kill();
				msg("Saving...");

				file.setValue("Url", save_dialog.getURL());
				Distiller output = new Distiller(file, MyApplet.getMyParameter("BackupURL"), MyApplet.getMyParameter("cfgWriter"));
				if (output.successful()) {
					msg("Cfg Output saved.");
					AWTHelper.warn("Congratulations.\n \nYou did all changes to get new/changed targets in your cfg file.\n \n" +
						"You now may want to:\n" +
						"  - If you changed your Cfg, you may want to delete the old gifs because they may be wrong\n" +
						"  - Run mrtg at least 3 times until all error messages are gone\n" +
						"  - Do some index file hacking for your web site\n" +
						"  - Edit your crontab entry using crontab -e.\n" +
						"  - Have fun with your new graphs.");

				}
				else { 
					AWTHelper.warn("There was a problem saving the Cfg.");
				}
			//}
		}
	}


// ---------------------------------------------- add_dialog ----------------


	/** Inner class for handling the action event of the add dialog--  button 1.
	 */
	class Add1 implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			if (! cfg_loaded) {
				AWTHelper.warn("Please load a Cfg first.");
			}
			else {

				if (add_dialog.getOpen()) {

					add_dialog.kill();

					ImportTarget import_target = new ImportTarget("Import Target", mc2);
					import_target.pack();
					import_target.show();
					InputChannel channel = new InputChannel(MyApplet.getMyParameter("cfgReader"), MyApplet.getMyParameter("WorkDir"), MyApplet.getMyParameter("IconDir"));
					String u = add_dialog.getURL();
					String d = add_dialog.getDevice();
					import_target.file = channel.getFromCgi(d, u);
					import_target.cfg_loaded = true;
					import_target.msg("Please choose the correct port number.");
					import_target.putIntoList();
				}
			}
		}
	}
// ------------------------------------------ line dialog ------------------------------



	/** Inner class for handling the action event of the add dialog--  button 1.
	 */
	class Check implements ActionListener {

		public void actionPerformed(ActionEvent e) {

			line_dialog.kill();
			checkport = new CheckPort("Check Port", mc2);
			checkport.pack();
			checkport.show();

			InputChannel channel = new InputChannel(MyApplet.getMyParameter("cfgReader"), MyApplet.getMyParameter("WorkDir"), MyApplet.getMyParameter("IconDir"));
			String u = line_dialog.getURL();
			checkport.file = channel.getFromCgi("DEVICE", u);
			checkport.cfg_loaded = true;
			checkport.msg("Please choose the correct port number.");
			checkport.putIntoList();
		}
	}

//----------------------------------------- interactive help ----------------------



	/** Inner class with the event handler for the mouse enter events. 
	 *
	 * @param s	String with the explanation
	 */
	class showInfo extends MouseAdapter {

		String s; // the text

		// Constructor
		showInfo(String s) {
			this.s = s;
		}
		
		public void mouseEntered(MouseEvent e) {
			msg(s);
		}
	}
}
