package ch.swisslife.ibgm.mc2;
import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

/** Dialog for opening or saving files. It reads the directory contents from the cgi DirectoryReader.
 * @author Michael Grob for RA/SL
 * @version 1.01 09/04/98
 */
public class ChooseDialog extends Frame {
	protected String AddressOfDirectoryReader;
	protected List directory_list;
	protected TextField field;
	protected Button button1, button2;
	protected Panel p = new Panel();
	protected String cfg_base, old;  // change it in final to do grab it from applet
	protected Label explanation;
	protected Label label1;
	protected Label label2;
	protected Label path;
	GridBagLayout gridbag = new GridBagLayout();		// Layout-Manager fuer alle container
	protected BufferedReader dataInput;


	/** Constructor with some arguments.
	 *
	 * @param address	String with address of cgi
	 * @param base		String with address of the cfg base
	 * @param title		String with title name
	 */	
	public ChooseDialog(String address, String base, String title) {
		this.super(title);
		AddressOfDirectoryReader = address;
		this.cfg_base = base;
		
		// instantiate the objects
		directory_list = new List(10,false);
		field = new TextField(40);
		field.setBackground(Color.white);

		p.setLayout(gridbag);
		this.setLayout(new GridBagLayout());
		this.setBackground(Color.lightGray);

		directory_list.addItemListener(new IL());
		directory_list.addFocusListener(new FLList(true));
		field.addFocusListener(new FLList(false));
	}

	/** Constructor with more arguments.
	 *
	 * @param address	String with address of cgi
	 * @param base		String with address of the cfg base
	 * @param title		String with title of the dialog
	 * @param parent	MyMessage: the parent class
	 * @param button_1	String: Name of button1
	 * @param button_2	String: Name of button2
	 * @param label_1	String: Name of label1
	 * @param lablel_2	String: Name of label2
	 * @param explanation	String: name of explanation label
	 */	
	public ChooseDialog(String address, String base, String title, String button_1, String button_2, String label_1, String label_2, String explanation) {
		this.super(title);
		AddressOfDirectoryReader = address;
		this.cfg_base = base;
		this.old = base;
		
		// instantiate the objects
		directory_list = new List(10,false);
		field = new TextField(40);
		field.setBackground(Color.white);


		p.setLayout(gridbag);
		this.setLayout(new GridBagLayout());
		directory_list.addItemListener(new IL());
		directory_list.addFocusListener(new FLList(true));
		field.addFocusListener(new FLList(false));

		// instantiate the other objects
		this.explanation = new Label(explanation);
		this.label1 = new Label(label_1);
		this.label2 = new Label(label_2);
		this.path = new Label("------------------------------------------------------------------");
		this.button1 = new Button(button_1);
		this.button2 = new Button(button_2);
		this.setBackground(Color.lightGray);

		
		path.setText(cfg_base + "                                                                  ");

		// put the objects into Layout
		AWTHelper.constrain(p, this.explanation, 0,0,2,1);
		AWTHelper.constrain(p, directory_list, 0,1,2,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, label1, 0,2,2,1);
		AWTHelper.constrain(p, path, 0,3,2,1);
		AWTHelper.constrain(p, label2, 0,4,2,1);
		AWTHelper.constrain(p, field, 0,5,2,1);
		AWTHelper.constrain(p, button1, 0,6,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,0,0,0);
		AWTHelper.constrain(p, button2, 1,6,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHEAST, 0.0,0.0,5,0,0,0);
		AWTHelper.constrain(this, p, 0,0,1,1, GridBagConstraints.NONE, GridBagConstraints.CENTER, 0.0,0.0,10,10,10,10);


		this.pack();
		this.show();
		GetDirectoryContents(cfg_base);

	}


	/** Constructor which calls the constructor of super class.
	 *
	 * @param title		String with title of the dialog.
	 */
	public ChooseDialog(String title) {
		super(title);
	}


	public void kill() {
		this.setVisible(false);
		this.dispose();
	}


	// INNER CLASSES FOR EVENTS

	class IL implements ItemListener {
		public void itemStateChanged(ItemEvent e) {
			String s = directory_list.getSelectedItem();
			listSelected(s.trim());
		}
	}


	class FLList implements FocusListener {

		boolean b;

		// constructor
		public FLList(boolean b) {
			this.b = b;
		}

		public void focusGained(FocusEvent e) {
			setDirectoryFocus(b);
		}
		public void focusLost(FocusEvent e) {
		}
	}


	public void setDirectoryFocus(boolean b) {

	}					
		
	
	public void listSelected(String s) {

	}


	public boolean getOpen() {
		return false;
	}


	public String getURL() {
	return "";
	}


	public String getDevice() {
	return "";
	}


	/** Cuts off the last char of a String
	 *
	 * @param s	String to be cut off
	 * @return String without last char of s
	 */
	public String removeLastChar(String s) {
		return s.substring(0, s.length()-1);
	}


	/** cuts of the last word (with a specified delimiter) of a String
	 * 
	 * @param s		String to be cut
	 * @param delimiter	String to serve as a delimiter
	 * @return String without the last word
	 */
	public String removeLastWord (String s, String delimiter) {
		s = removeLastChar(s);

		do {
			s = removeLastChar(s);
		}
		while (s.charAt(s.length() -1) != delimiter.toCharArray()[0]);
		return s;
	}

			
	/** puts the content of a directory into the list.
	 */	
	protected void ShowContentsOfDirectory() {

		String Line;
		int Index = 1;
		try{
			directory_list.removeAll();
			Line = dataInput.readLine();
			directory_list.addItem("..",0);

			while((Line != null)&&(Line.length() != 0)) {
				directory_list.add(Line,Index++);
				Line = dataInput.readLine();
				
			}
			directory_list.select(1);
			cfg_base = cfg_base + directory_list.getItem((1));
			cfg_base = cfg_base.trim();
			path.setText(cfg_base);
			dataInput.close();
		}
		catch(IOException e){	
			String Message = "IOException while reading Error-Messages from DirectoryReader:" + e +"\n";
			AWTHelper.warn(Message);
		}	

	}
		
	
	protected void GetDirectoryContents(String Directory) {
		URL DirectoryReaderURL = null;
		path.setText(Directory);
		String URLWithQueryString = AddressOfDirectoryReader + "?BASE=" + Directory;
		try {	
			DirectoryReaderURL = new URL(URLWithQueryString);
		}
		catch(MalformedURLException e) {
		
		  	String Message = "MalformedURLException occured in'GetDirectoryContents.\n"
		  		+"Maybe syntax error in URL: " 
		  		+ Directory + "\n";
			AWTHelper.warn(Message);
		}		
		try{
			URLConnection Connection = DirectoryReaderURL.openConnection();

			// try to avoid caching the cgi results

			Connection.setUseCaches(false);
			dataInput = new BufferedReader(new InputStreamReader( Connection.getInputStream()));
			ShowContentsOfDirectory();
		}
		catch(IOException e){
			String Message = "IO Exception occured, " + e + "\nMaybe you don't have the correct access privileges?";
			//cfg_base = removeLastWord(cfg_base, "/");
			cfg_base = old;
			path.setText(cfg_base);
			AWTHelper.warn(Message);
			directory_list.add("..");
		}
		old = cfg_base;

	}	
}
