package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.util.Vector;

/** Java  data structure for CFG files.
 * Represents a CFG File with its targets. The tagets are stored in a Vector.
 * 
 * @autor	Michael Grob for RA/SL
 * @version	1.01, 09/04/98
 */
public class Cfg extends Object implements java.lang.Cloneable {

	Vector Targets = new Vector(); // Vector for putting the Elements in
	String Url = new String(); 		// URL of the file
	String WorkDir = new String();		// URL of working directory
	String IconDir = new String();		// URL of IconDir, should be constant
	String Interval = new String("5");	// Time between measurements, standard value 5 min
	String Refresh = new String("300");	// Time between html Page is refreshed; 
						// standard value 5 min
						
	/** Constructor for Class Cfg. Does nothing than call the constructor of the super class.
	 *
	 */
	public Cfg() {
		this.super();
	}

	/** Constructor for Class Cfg with URL where file is stored. 
	 *
	 * @param url		String containing URL of storage location of this Cfg file
	 */
	public Cfg(String url) {
		this.super();
		this.Url = url;
	}



	/** Clones itself and its Objects.
	 *
	 * @return A CFG as a copy of itself
	 */
	public Object clone() throws java.lang.CloneNotSupportedException {
		Cfg cloned = new Cfg();
		int i = 0;
		while (i < this.Targets.size()) {
			Target t = new Target("test");
			Target t_old = (Target) this.Targets.elementAt(i);
			t = t_old.copy(t);
			cloned.Targets.insertElementAt(t, i);
			i++;
		}
		cloned.Url = new String(this.Url);
		cloned.WorkDir = new String(this.WorkDir);
		cloned.IconDir = new String(this.IconDir);
		cloned.Interval = new String(this.Interval);
		cloned.Refresh = new String(this.Refresh);
		return cloned;
	}


	/** Constructor for class CFG with URL, WorkDir and IconDir Parameters.
	 * Usually, the IconDir and WorkDir location doesn't change, so it can be specified
	 * in the constructor.
	 *
	 * @param url	String containing URL of storage location of this Cfg file
	 * @param wd	String containing URL of WorkDir
	 * @param id	String containing URL of IconDir
	 */
	public Cfg(String url, String wd, String id){
		this.super();
		this.Url = url;
		this.WorkDir = wd;
		this.IconDir = id;
	}
	

	/** Constructor for class CFG WorkDir and IconDir Parameters.
	 * Usually, the IconDir and WorkDir location doesn't change, so it can be specified
	 * in the constructor.
	 *
	 * @param wd	String containing URL of WorkDir
	 * @param id	String containing URL of IconDir
	 */
	public Cfg(String wd, String id){
		this.super();
		this.WorkDir = wd;
		this.IconDir = id;
	}

	/** Creates new Target, prepends it to the vector and returns its index 
	 * 
	 * @param name	String containing name of this target
	 * @return 	int which contains the position of this target in the vector
	 *
	 */
	public int newTarget(String name) {
		Target t = new Target(name);
		// put it at the beginning, so we can always return 0
		Targets.insertElementAt(t, 0);
		return 0;
	}
	
	/** Prepends a target to the vector and returns its index 
	 * 
	 * @param name	String containing name of this target
	 * @return 	int which contains the position of this target in the vector
	 *
	 */
	public int addTarget(Target t) {
		Targets.insertElementAt(t, 0);
		return 0;
	}

	
	/** Returns the index of this target.
	 * 
	 * @param name	String with the name of this target ("Target" = x)
	 * @return int with position of the target if target in vector;
	 * -1 otherwise.
	 */
	public int getIndex(String name) {
		
		int size = this.Targets.size();
		for (int i =0; i < size; i++) {
			Target t = (Target) Targets.elementAt(i);
			if (name.equals(t.getValue("Target"))) {
				return i;
			}
		}
		return -1; // no match found
	}
	
	
	/** Deletes the target; String Version.
	 * Does the other elements to change position in the vector?
	 * 
	 * @param name	String with name of this target.
	 * 
	 */
	public void deleteTarget(String name) {
		int i = this.getIndex(name);
		this.Targets.removeElementAt(i);
	}
	
	
	/** Deletes the target; int Version.
	 * Does the other elements to change position in the vector?
	 * 
	 * @param i	int with position of this target in vector.
	 * 
	 */
	public void deleteTarget(int i) {
		this.Targets.removeElementAt(i);
	}

	
	/** Checks whether a Target exists (is in vector) or not; String version.
	 * 
	 * @param name	String with name of this target.
	 * @return	<code>true</code> if targets exist, <code>false</code> otherwise.
	 */
	public boolean existTarget(String name) {
		if (this.getIndex(name) >= 0) {
			return true;
		}
		return false;	
	}

		
	/** Checks whether a Target exists (is in vector) or not; int version.
	 * 
	 * @param i	int with position of this target in vector.
	 * @return	<code>true</code> if targets exist, <code>false</code> otherwise.
	 */
	public boolean existTarget(int i) {
		if (i < this.Targets.size()) {
			return true;
		}
		return false;
	}
	

	/** Gets a value of the Target; String version.
	 * Uses <code>Target.getValue</code>; avoids calling it directly.
	 *
	 * @param name 		String with name of this target
	 * @param option	String with name of the option asked for
	 * @return 		String with the value of the option asked for
	 */
	public String getValue(String name, String option) {
		int i = this.getIndex(name);
		Target t = (Target) this.Targets.elementAt(i);
		String s = t.getValue(option);
		return s;
	}


	/** Gets a value of the Target; int version.
	 * Uses <code>Target.getValue</code>; avoids calling it directly.
	 *
	 * @param i 		int with position of this target in vector
	 * @param option	String with name of the option asked for
	 * @return 		String with the value of the option asked for
	 */
	public String getValue(int i, String option) {
		Target t = (Target) Targets.elementAt(i);
		return t.getValue(option);
	}


	/** Gets the "global" fields stored in this Cfg file directly. 
	 * Note: the only difference to the other <code>setValue</code> methods is the number
	 * of arguments!
	 * 
	 * @param arg	String with the name of the value asked for
	 */
	public String getValue(String arg) {
		if (arg.equals("WorkDir")) {
			return this.WorkDir;
		}
		else if (arg.equals("IconDir")) {
			return this.IconDir;
		}
		else if (arg.equals("Interval")) {
			return this.Interval;
		}
		else if (arg.equals("Refresh")) {
			return this.Refresh;
		}
		else if (arg.equals("Url")) {
			return this.Url;
		}
		else {
			return "";
		}
	}
	
	
	/** Gets the number of targets in this Cfg file.
	 *
	 * @return int with number of targets in this Cfg file.
	 */
	public int getNumberOfTargets () {
		return this.Targets.size();
	}
	
	
	/** Sets a value of this target; String version.
	 * 
	 * @param name		String with the name of this target
	 * @param option	String with the name of the option to set
	 * @param value		String with the value to be set	
	 * @return <code>true</code> if successfull, <code>false</code> otherwise.
	 */
	public boolean setValue(String name, String option, String value) {
		int i = this.getIndex(name);
		Target t = (Target) this.Targets.elementAt(i);
		return (t.setValue(option, value));
	}
		
	/** Sets a value of this target; int version.
	 * 
	 * @param i		int with the position of this target in vector
	 * @param option	String with the name of the option to set
	 * @param value		String with the value to be set	
	 * @return <code>true</code> if successfull, <code>false</code> otherwise.
	 */
	public boolean setValue(int i, String Option, String Value) {
		Target t = (Target) this.Targets.elementAt(i);
		return (t.setValue(Option, Value));
	}
	
	/** Sets one of the values stored in the Cfg file directly.
	 * Note: the only difference to the other <code>setValue</code> methods is the number
	 * of arguments!
	 * 
	 * @param arg	String with the name of the field to set
	 * @param value	String containin the value to be set
	 * @return 	<code>true</code> if successful, <code>false</code> otherwise
	 */
	public boolean setValue(String arg, String value) {
		if (arg.equals("WorkDir")) {
			this.WorkDir = value;
			return true;
		}
		else if (arg.equals("IconDir")) {
			this.IconDir = value;
			return true;
		}
		else if (arg.equals("Interval")) {
			this.Interval = value;
			return true;
		}
		else if (arg.equals("Refresh")) {
			this.Refresh = value;
			return true;
		}
		else if (arg.equals("Url")) {
			this.Url = value;
			return true;
		}
		else {
			return false;
		}
	}
	

	/** Tests if the vector is empty, which means no targets in Cfg file.
	 *
	 * @return <code>true</code> if empty, <code>false</code> otherwise.
	 */
	public boolean isEmpty() {
		return this.Targets.isEmpty();
	}
	
	
	/** Main method of this class; used for testing only.
	 * Calls <code> test</code>
	 *
	 * @param argv[]	String argument vector; not used, just for compatibility,
	 */
	public static void main (String argv[]) {

	}		
}
