package ch.swisslife.ibgm.mc2;
import java.awt.*;

/** this class defines some important methods for AWT.
 * It can not be instantiated.
 *
 * @author 	Michael Grob for RA/SL
 * @version 	1.01, 09/04/98
 */

public class AWTHelper {
	
	/** constrain method: arguments for all constraints.
	 *  sets up the user interface/
	 * @param container	Container
	 * @param component	Component
	 * @param grid_x	int
	 * @param grid_y	int
	 * @param grid_with	int
	 * @param grid_height	int
	 * @param fill		int
	 * @param anchor	int
	 * @param weight_x	int
	 * @param weight_y	int
	 * @param top		int
	 * @param left		int
	 * @param bottom	int
	 * @param right		int
	 */
	public static void constrain(Container container, Component component, int grid_x, int grid_y,int grid_with, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right)
	{
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = grid_x; c.gridy = grid_y;
		c.gridwidth = grid_with; c.gridheight = grid_height;
		c.fill = fill; c.anchor = anchor;
		c.weightx = weight_x; c.weighty = weight_y;
		if (top+bottom+left+right > 0)
			c.insets = new Insets(top, left, bottom, right);
			
		((GridBagLayout)container.getLayout()).setConstraints(component, c);
		container.add(component);
	}

	
	/** constrain method: no margins, no resize.
	 *  sets up the user interface/
	 * @param container	Container
	 * @param component	Component
	 * @param grid_x	int
	 * @param grid_y	int
	 * @param grid_with	int
	 * @param grid_height	int
	 */

	public static void constrain(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height) {
		constrain(container, component, grid_x, grid_y, grid_width, grid_height, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
	}

	/** constrain method: no resize, but margins.
	 *  sets up the user interface/
	 * @param container	Container
	 * @param component	Component
	 * @param grid_x	int
	 * @param grid_y	int
	 * @param grid_with	int
	 * @param grid_height	int
	 * @param top		int
	 * @param left		int
	 * @param bottom	int
	 * @param right		int
	 */
	public static void constrain(Container container, Component component, int grid_x, int grid_y, int grid_width, int grid_height,int top, int left, int bottom, int right) {
		constrain(container, component, grid_x, grid_y, grid_width, grid_height, 
		GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,top, left, bottom, right);
	}
		

	/** Invokes a warn dialog with a text and an ok button.
	 * It is used by all classes in the package to diplay error or warn dialogs.
	 *
	 * @param message	String containing the error message
	 */
	public static void warn(String s) {
		Frame f = new Frame("");
		WarnDialog d = new WarnDialog(f, "Warning:", s);
		d.show();
	}

}
