#!/usr/bin/perl
# This small utility is used to collect the available memory and
# used memory. For free memory, it sums the free, cached and buffers.
# 
# v1.0 - Jason C. Hill <jhill@technoslave.net>
#
# Please look at the included mrtg.cfg to figure out how to add this utility
# to your own MRTG.
#
# Output Format:
#
# Used memory
# Free memory
# # days, HH:MM:SS
# Machine Name
#
# Concept based on original work by Colin Tinker
# g1gsw@titanic.demon.co.uk


# Vars
my($machine);

$machine = "gimp";

# Let's start.

@getmeminfo = `cat /proc/meminfo`;

  foreach $item(@getmeminfo) {
    if ($item =~ /^Buffers:\s+(\d+)\s/) {
      $buffers = $1;
    }
    if ($item =~ /^Cached:\s+(\d+)\s/) {
      $cached = $1;
    }
    if ($item =~ /^HighFree:\s+(\d+)\s/) {
      $highfree = $1;
    }
    if ($item =~ /^LowFree:\s+(\d+)\s/) {
      $lowfree = $1;
    }
    if ($item =~ /^SwapTotal:\s+(\d+)\s/) {
      $swaptotal = $1;
    }
  }

#  Total
$freemem = $buffers + $cached + $highfree + $lowfree;

# Used memory 
$usedmem = $swaptotal - $freemem;

print $freemem."\n";
print $usedmem."\n";

# Get uptime - Do it the right way, MRTG doesn't seem to do it quite right.
$curuptime = `cat /proc/uptime`;

$curuptime =~ /^(\d+)/;

# Unless someone has a better way of either getting a Day HH:MM:SS format
# out of seconds, and/or someone knows how get floats to ints without using
# printf...which I don't feel like using...I know there's a math operator
# that does a divide and drops the decimals...but I can't think of it right
# now.

$days = int $1/86400;
$tmphours = $1 - ($days * 86400);
$hours = int $tmphours/3600;

$tmpmin = $1 - ($days * 86400) - ($hours * 3600);
$minutes = int $tmpmin/60;

$seconds = $1 - (($days * 86400) + ($hours *3600) + ($minutes * 60));

print "$days days, $hours:$minutes:$seconds\n";
print $machine."\n";
