####
$firsttime = 0;	
#0 = false, 1=true. Only set to 1 first time.
####

BEGIN {
    # Automatic OS detection ... do NOT touch
    if ( $^O =~ /^(ms)?(dos|win(32|nt)?)/i ) {
	$main::OS = 'NT';
	$main::SL = '\\';
	$main::PS = ';';
    } elsif ( $^O =~ /^VMS$/i ) {
	$main::OS = 'VMS';
	$main::SL = '.';
	$main::PS = ':';
    } else {
	$main::OS = 'UNIX';
	$main::SL = '/';
	$main::PS = ':';
    }
    $SIG{__WARN__} = sub { my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                localtime(time);
                           $year += 1900;
                           $mon += 1;
                           my $now = sprintf "%4d-%02d-%02d %02d:%02d:%02d", $year,$mon,$mday,$hour,$min,$sec;
                           print STDERR "$now -- $_[0]" };

    $SIG{__DIE__} = sub { my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                                localtime(time);
                           $year += 1900;
                           $mon += 1;
                           my $now = sprintf "%4d-%02d-%02d %02d:%02d:%02d", $year,$mon,$mday,$hour,$min,$sec;
                           print STDERR "$now -- $_[0]"; exit 1};

}

use FindBin;
use lib "${FindBin::Bin}";
use lib "${FindBin::Bin}${main::SL}..${main::SL}lib${main::SL}mrtg2";

use MRTG_lib;
use Time::Local;
use POSIX;

my $cfgfile = shift @ARGV;
readcfg($cfgfile,\@routers,\%cfg,\%rcfg);

if (defined $cfg{'logdir'}) {
	$datadir = $cfg{'logdir'};
} else {
	$datadir = $cfg{'workdir'};
}

foreach $router (@routers) {
	if($firsttime eq 1) {
		#einddatum is afgelopen nacht
		my ($seconds, $minutes, $hour, $monthday, $month, $year, $weekday, $yearday, $isdist) = localtime(time);
		my $startdate = timelocal(0,0,0,$monthday,$month,$year);
		#start is begin deze maand
		my $enddate = timelocal(0,0,0,1,$month,$year);		
		my $num = $monthday;		#aantal dagen ertussen
		open(FILE, ">$datadir$main::SL$router.data");
		my $yeara= $year+1900;
		my $maand = $month+1;
		if ($maand < 10) { $maand = "0$maand"; }
		
		for($j=1; $j<$num; $j++) {
			$enddate = timelocal(0,0,0,$j+1,$month,$year);
			$startdate = timelocal(0,0,0,$j,$month,$year);
			my($in, $out) = &get_totals($router, $startdate, $enddate);
			$dag = $j;
			if ($dag < 10) { $dag = "0$dag"; }
			print FILE "$yeara$maand$dag\t$in\t$out\n";
		}
		close(FILE);
		print "Finished making first data file for $router\n";
	}
	else {
		my @dataverkeer;
		my ($seconds, $minutes, $hour, $monthday, $month, $year, $weekday, $yearday, $isdist) = localtime(time);
		my $year = $year+1900;
		
		if ($maand < 10) { $maand = "0$maand"; }
		
		my $enddate = timelocal(0,0,0,$monthday,$month,$year);
		my $startdate = timelocal(0,0,0,$monthday-1,$month,$year);

		my ($secondsa, $minutesa, $houra, $monthdaya, $montha, $yeara, $weekdaya, $yeardaya, $isdista) = localtime($startdate);
		$dag = $monthdaya;	
		my $maand = $montha+1;
		
		if ($dag < 10) { $dag = "0$dag"; }
		if ($maand < 10) { $maand = "0$maand"; }
		
		my($in, $out) = &get_totals($router, $startdate, $enddate);

		open(FILE, "$datadir$main::SL$router.data");
		while(<FILE>) {
			@tmp_array = split;
			push @dataverkeer , [ @tmp_array ];
		}
		close(FILE);
		open(FILE, ">$datadir$main::SL$router.data") or die "Couldn't open data file";		
		for $x ( 0 .. $#dataverkeer ) {
			if ($dataverkeer[$x][0] ne "$year$maand$dag") { 
				print FILE $dataverkeer[$x][0]."\t".$dataverkeer[$x][1]."\t".$dataverkeer[$x][2]."\n";								
			}
		}		
		print FILE "$year$maand$dag\t$in\t$out\n";
		close(FILE);
	}
}

sub get_totals {
   my($log,$start,$end) = @_ if @_;
   my($itot,$otot,$interval) = (0,0,0);
   my($aline,$curr_date,$avg_in,$avg_out,$pin,$pout,$tot);
   # File is in reverse, from end to start, so we count down...
   my($prev_date) = time;
   open(LOG,"$datadir$main::SL$router\.log") or die "Couldn't open file: $datadir$main::SL$router\.log";
   while (<LOG>) {
      $aline = $_;
      chomp($aline);
      ($curr_date,$avg_in,$avg_out,$pin,$pout) = split(' ',$aline);
      $interval = $prev_date - $curr_date; 
      $prev_date = $curr_date;
      next if ($curr_date > $end);
      next if ($curr_date < $start);
      $itot = $itot + ($avg_in * $interval);
      $otot = $otot + ($avg_out * $interval);
   }
#   $tot = $itot + $otot;
   return($itot, $otot);
   close(LOG);
}