#!/usr/bin/perl -w
#
# script to get FlexDSL modem error numbers (DSL and Eth)
#
# CopyLeft (L) Dmitry A.Provodnikov, 2003
# any comments to provodnikov(q)mail.ru

# use strict;

my $pass = $ARGV[0];
my $addr = $ARGV[1];

if (!defined($addr)) { print "Usage: $0 modem_password modem_FQDN_or_IP\n"; exit; };

use Net::Telnet;

my $port = 23;
my $t;
my $rc;

my $err_dsl="UNKNOWN";
my $err_eth="UNKNOWN";

my $p=">FlexDSL>";

$t = new Net::Telnet ( Host => $addr,
	Port => $port,
	Telnetmode => 0, Timeout=>5);

$t->errmode(\&err_hndlr);

$t->open("$addr");

$t->waitfor('/password:/');

$t->print($pass);

$t->waitfor('/\>/');
$t->print("home");

$t->waitfor('/\>/');
$t->print("home");

my $line = "";

$t->print("list");

while (defined ($line=$t->getline) ) {
	chomp($line);
	if ($line =~ /^[\s]+0\:[\s]+bridge[\s]+/) {
		my @ea=split(/[\:\/\ ]+/, $line);
		$err_dsl=$ea[8];
	};
	if ($line =~ /^[\s]+0\:[\s]+edd[\s]+/) {
		my @ea=split(/[\:\/\ ]+/, $line);
		$err_eth=$ea[8];
	};
	if (($err_dsl ne "UNKNOWN") && ($err_eth ne "UNKNOWN")) {
		last;
	};
};

$t->print("\@exit");
$t->close;

print $err_dsl;
print "\n";
print $err_eth;
print "\n";
print "UNKNOWN\n";
# I don't know how to get uptime
print $addr;
print "\n";
exit;

sub err_hndlr()
{
print "UNKNOWN\n";
print "UNKNOWN\n";
print "UNKNOWN\n";
print $addr;
print "\n";
exit(1);
}
