#!/usr/bin/perl -w

# please use
# 	SAA_start .pl -man
# to view the manpage of this script

##################################################################
#           PLEASE MODIFY THE FOLLOWING TO INSTALL               #
# point the path below to the location of the RttMon* libs
use lib qw(/usr/local/SAA/lib /usr/local/SNMP/lib);
#                PLEASE DO NOT MODIFY AFTER THIS                 #
##################################################################

use ciscoRttMonLib "0.2";
&ciscoRttMonLib::start();

=head1 NAME

SAA_start.pl - create and start a SAA probe on a Cisco IOS device

=head1 SYNOPSIS

B<>SAA_start.pl -configfile I<filename> [-debug] 

SAA_start.pl -man

=head1 DESCRIPTION

Please read the fetchstart.pl manual page first.

SAA_start creates and starts a SAA probe on a Cisco IOS device.

Command line arguments are:

=over 1

=item -configfile I<filename> 

mandatory. The configuration file for the SAA probe. See also "Probe Configuration File Syntax" below.

=item -debug

optional. Prints all measured / calculated values and verbose errors.

=head1 AUTHOR

Joerg.Kummer at Roche.com 

=cut

