#!/usr/bin/perl -w

# please use
# 	SAA_fetchstart .pl -man
# to view the manpage of this script

##################################################################
#           PLEASE MODIFY THE FOLLOWING TO INSTALL               #
# point the path below to the location of the RttMon* libs
use lib qw(/usr/local/SAA/lib /usr/local/SNMP/lib);
#                PLEASE DO NOT MODIFY AFTER THIS                 #
##################################################################

use ciscoRttMonLib "0.2";
&ciscoRttMonLib::fetchstart(0==1);

=head1 NAME

SAA_fetchstart.pl - report Cisco SAA data in MRTG

=head1 SYNOPSIS

B<>SAA_fetchstart.pl -configfile I<filename> [-debug] [-cache I<secs>] [-log I<filename>] [-line0 I<line0format>] ..  [-line9 I<line9format>]

SAA_fetchstart.pl -man

=head1 DESCRIPTION

SAA_fetchstart is an interface between a MRTG host and a Cisco IOS device running SAA (formerly RTR). It allows to include the results of SAA round trip time and loss measurements in MRTG.

An SAA probe on a Cisco IOS device executes multiple latency measurements ("Rtt Operations") in its "life" time and stores statistical data on the measured response times and optionally individual operation results (history). SAA probes on a Cisco are identified by their "entry" number (in SNMP speak: their conceptual row index).

SAA_fetchstart requires

=over 2

=item *

one configuration file per SAA probe

=item *

command line parameters determining which statistical values to provide to MRTG

=back

During its first invocation SAA_fetchstart creates and starts one SAA probe on the Cisco, e.g. the Cisco starts pinging and storing ping results into MIB variables for this probe's entry number. The configuration for the SAA probe is taken from the file specified by the '-configfile' CLI parameter to SAA_fetchstart.

In the second SAA_fetchstart invocation, the measurement results are polled from the IOS box and stored into a cache file. Then SAA data on the Cisco is deleted, the SAA probe is configured again and started. The CLI arguments -line0 .. -line9 determine, which of the cached values SAA_fetchstart writes to stdout(from where they are typically read by MRTG).

If a subsequent SAA_fetchstart invocation occurs within the cache timeout interval(see -cache CLI option), then data from the cache is returned. Otherwise the same process as in invocation #2 is followed. 

The cache was implemented, because MRTG was designed to store only two values per target (traditionally in and out load). Using the cache it is possible to create multiple two-value MRTG graphs based on the same SAA_fetchstart cache data. An MRTG configuration containing

 Target[SAA1]: `SAA_fetchstart.pl -co LondonParis -1 max -2 min`
 Target[SAA2]: `SAA_fetchstart.pl -co LondonParis -1 avg -2 med`

creates two graphs - one with min/max values of the SAA measurement between London and Paris; the second with median and average values between London and Paris (-1 is short for -line1). Because of the cache the Cisco is only polled once per MRTG 5 minute cycle.

=head1 COMMAND LINE ARGUMENTS

=over 1

=item -configfile I<filename> 

The configuration file for the SAA probe. See also "Probe Configuration File Syntax" below.

=item -debug

Prints all measured / calculated values and verbose errors.

=item -cache I<secs>

The cache timeout in seconds. Default is 270 seconds. Use a timeout value of 1 to force an SNMP poll. 

=item -log I<filename>

Logs data each time SAA_Fetch is invoked into a file I<filename> in the directory $tmppath (see below). 

=item -line0 I<line0format>] ..  -line9 I<line9format>

Defines the output format, i.e. line0 will be printed first, line1 second etc. -line0 can be abbreviated as -0, line1 as -1 etc. The argument to the line option is one of the following

 n     - number of measurements performed 
 drp   - drops / number of failed measurements
 dpr   - percentage of failed to total number of measurements
 ava   - availability - 1 if any ping was succesful, 0 otherwise
 avp   - availability percentage - like ava with 100/0
 med   - median latency
 avg   - average latency
 min   - minimum latency 
 max   - maximum latency
 var   - latency variance
 std   - standard deviation (sqrt (variance) ) of latency
 cov   - covariance (standard deviation/average) of latency
 ams   - average - standard deviation of latency
 aps   - average + standard deviation of latency
 <any> - constant string / number values (except the ones above)

Please note that the SAA probe must use history to allow median calculation. See also "Probe Configuration File Syntax" below.

=back

=head1 PROBE CONFIGURATION FILE SYNTAX

A perl 'eval' statement executes the configuration file, i.e. standard perl syntax applies. The file must include assignments to the following variables:

=over 1

=item $ioshost

The IOS device, which will execute the SAA probe (DNS or numeric IP address required)

=item $community 

The SNMP community string, which will be used to read/write access the ciscoRttMon MIB

=item $entry 

The entry number on the IOS device (1..2147483647).

=item @myparms

A list of triplets: variable name, variable type, value. Those are the SNMP variables SAA_fetchstart sets to create the SAA probe on the IOS device.

=back

=head2 SAA Probe Types

This distribution includes samples for each of the working/tested SAA probe types. At the time of writing the types ipIcmpEcho, tcpConnect, udpEcho, dns, dhcp, ftp were tested successfully. The type frame-relay should work in theory, but wasn't tested. 
Http, jitter, pathEcho and pathJitter are currently not supported by SAA_fetchstart because they use a different part of the ciscoRttMon MIB to report their results.

=head2 History Collection

SAA probes work in two modes - with or without history collection. Without history collection only statistical values about the complete set of probe operations are stored, e.g. the number of all probe operations, the sum of the response times, the sum of the squares of the response times. With history the individual response times are stored in a history table.

History collection is a pre-requisite for median calculation. 

Before IOS 12.3 (12.2(11)T) the maximum number of "history buckets" was 20. So, if you wish to use median it doesn't make sense to execute more than 20 SAA probe operations per MRTG 5 minute cycle (this is why the frequency in many sample probe configuration files is 14 seconds).

=head1 IOS and MRTG configuration

The router(s) must be configured to allow read/write SNMP access to the RTTMon MIB. Sufficient is:

	snmp-server community RTTCommunity RW
 
If you want to be a bit more restrictive with SNMP write access to the Cisco, then consider configuring something like this 

	access-list 2 permit 10.37.3.5
	snmp-server view RttMon ciscoRttMonMIB included
	snmp-server community RTTCommunity view RttMon RW 2

The above configuration grants SNMP read-write only to 10.37.3.5 (the MRTG host) and only to the ciscoRttMon MIB tree. The probe does not need access to any SNMP variables outside the RttMon tree.

=head1 BUGS

I encountered a number of IOS bugs - some leading to IOS reloads. So, I recommend to use SAA_fetchstart with routers running IOS 12.0(3)T or higher and to test it on less critical routers first. 

If the DNS hostname in the URL of an ftp probe is not resolvable, the router crashes - Cisco bug id is CSCin19616; fixed in IOS 12.2(12.14).

I had one router crash using the history with IOS 12.0(5)T (Cisco 3640): writing many more than the maximum number of history entries eventually seems to have caused the crash (IOS rttMon circular buffer implementation seems buggy). The problem could NOT be reproduced on 12.2(8)T1 (Cisco 806).

I observed multiple routers (Cisco 7500, 12.1(12b) and Cisco 2600, 12.1(19), Cisco 3640, 12.2(19a) ) logging a text similar to the one below. 

 4w0d: %RTT-3-SemaphoreInUse: %RTR: Could not obtain a lock for RTR. Process 53
 4w0d: %RTT-3-SemaphoreBadUnlock: %RTR: Attempt to unlock semaphore by wrong RTR process 53, locked by 63
 4w0d: %SCHED-3-STUCKMTMR: Sleep with expired managed timer 80F54534, time 0x23811CDC (3w0d ago).
    -Process= "RTR Scheduler", ipl= 6, pid= 53
    -Traceback= 802F2D00 802F2FD8 807EC75C 80305420
 4w0d: %RTT-3-SemaphoreInUse: %RTR: Could not obtain a lock for RTR. Process 55

At the moment I believe this is related to situations in which multiple MRTG hosts SNMP-access the rttMon MIB on the Cisco simultaneousuly. The effect is that the SAA probe does not perform new SAA operations and keeps returning the same measurement values. 

I tested the cache mechanism on my installation only. It is possible that the cache timeout needs adjustment in larger installations (e.g. make it closer to but still less than 5 minutes); maybe in some installations a separate MRTG process for SAA_fetchstart is required to keep the time between the SAA_fetchstart invocations for the same SAA probe within the cache timeout interval.

I didn't test SAA_fetchstart with the enhanced-history functionality, which was introduced in 12.3 (12.2(11)T).

I only tested SAA_fetchstart, SAA_start, SAA_fetchrestart and SAA_delete under Solaris 2.8.

=head1 SEE ALSO

The best source for background info on SAA is Cisco's documentation on http://www.cisco.com and the CISCO-RTTMON-MIB documentation, which is available at: 
ftp://ftp.cisco.com/pub/mibs/v2/CISCO-RTTMON-MIB.my 

Cisco "SNMP object navigator" on http://www.cisco.com.

Cisco documentation on IOS CLI commands "show rtr ..".

This distribution includes probe configuration examples; a file mapping 'show rtr' output values to SNMP variables; 

http://people.ee.ethz.ch/~oetiker/webtools/mrtg/

http://people.ee.ethz.ch/~oetiker/webtools/smokeping/

http://www.switch.ch/misc/leinen/snmp/perl/

http://www.ietf.org/html.charters/ippm-charter.html

=head1 AUTHOR

Joerg.Kummer at Roche.com 

=cut

