#!/usr/bin/perl -w

# please use
# 	SAA_fetchrestart .pl -man
# to view the manpage of this script

##################################################################
#           PLEASE MODIFY THE FOLLOWING TO INSTALL               #
# point the path below to the location of the RttMon* libs
use lib qw(/usr/local/SAA/lib /usr/local/SNMP/lib);
#                PLEASE DO NOT MODIFY AFTER THIS                 #                    
##################################################################

use ciscoRttMonLib "0.2";
&ciscoRttMonLib::fetchstart(0==0);

=head1 NAME

SAA_fetchrestart.pl - report Cisco SAA data in MRTG

=head1 SYNOPSIS

B<>SAA_fetchrestart.pl -configfile I<filename> [-debug] [-cache I<secs>] [-log I<filename>] [-line0 I<line0format>] ..  [-line9 I<line9format>]

B<>SAA_fetchrestart.pl -ioshost I<IOSdevice> -community I<SNMPcommunity> -entry I<ProbeNumber> [-history] [-debug] [-cache I<secs>] [-log I<filename>] [-line0 I<line0format>] ..  [-line9 I<line9format>]

SAA_fetchrestart.pl -man

=head1 DESCRIPTION

Please read the fetchstart.pl manual page first.

The difference between fetchstart.pl and fetchrestart.pl is that fetchrestart.pl does not send the complete SAA probe configuration to the IOS device, if the SAA probe already exists on the IOS device. It therefore saves one SNMP set request per polling cycle. 

The SAA probes on the IOS device can be configured using SAA_start or the IOS CLI.

=head1 COMMAND LINE ARGUMENTS

=over 1

=item -configfile I<filename> 

The SAA probe configuration file.

=item -ioshost I<IOSdevice>

The IP address / DNS name of the IOS device.

=item -community I<SNMPcommunity>

The SNMP community of the IOS device.

=item -entry I<ProbeNumber>

The entry number on the IOS device (1..2147483647).

=item -history

Please use this, if you configured the Cisco with history (see also History Collection in the SAA_fetchstart manpage).

=item -debug

Prints all measured / calculated values and verbose errors.

=item -cache I<secs>

The cache timeout in seconds. Default is 270 seconds.

=item -log I<filename>

Logs data each time SAA_Fetch is invoked into a file I<filename> in the directory $tmppath (see INSTALL file). 

=item -line0 I<line0format>] ..  -line9 I<line9format>

Defines the output format, i.e. line0 will be printed first, line1 second etc. -line0 can be abbreviated as -0, line1 as -1 etc. The argument to the line option is one of the following

 n     - number of measurements performed 
 drp   - drops / number of failed measurements
 dpr   - percentage of failed to total number of measurements
 ava   - availability - 1 if any ping was succesful, 0 otherwise
 avp   - availability percentage - like ava with 100/0
 med   - median latency
 avg   - average latency
 min   - minimum latency 
 max   - maximum latency
 var   - latency variance
 std   - standard deviation (sqrt (variance) ) of latency
 cov   - covariance (standard deviation/average) of latency
 ams   - average - standard deviation of latency
 aps   - average + standard deviation of latency
 <any> - constant string / number values (except the ones above)

Please note that the SAA probe must use history to allow median calculation. See also "Probe Configuration File Syntax" below.

=head1 AUTHOR

Joerg.Kummer at Roche.com 

=cut

