#!/bin/sh
# $Id: t-mt-1.sh,v 1.7 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# simple mailertable routing tests by contacting SMAR
# uses t-smar-1 and startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=mt-1.out
IP=mt-1.ip
OK=mt-1.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${SOCK} ${PIDS}

# prepare mailertable
${CAT} > ${MT} <<EOF
.		[1.2.3.9]
local.dom	lmtp:
EOF

# create map for smar
rm -f ${ALIMAP}
${MM} <<EOF
user:	local:
EOF
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1

rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
# valid local user
${VALGRIND} ${TPRG} -Ml -VVVV '<user@local.dom>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=2
# ----------------------------------------
# unknown local user
${VALGRIND} ${TPRG} -Ml -VVVV '<unknown@local.dom>' > ${OUT} 2>&1
egrep '^(IP|WARN|ERROR)' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
WARN: lookup=REJECT
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

#rm -f ${OUT} ${IP} ${OK}

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
rm -f ${MTMAP}

exit ${ERRS}
