/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_sc_id.c,v 1.24 2005/04/11 18:12:48 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/io.h"
#include "sm/mta.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "sm/pthread.h"

/*
**  Notice: locking is currently done via dadb_ctx (qsc_id_next() is only
**  called from libdadb/dadb.c); SM_USE_SMTPC_MUTEX is not used.
*/

/*
**  QSC_ID_INIT -- initialize session/transaction id counter for SMTPC
**
**	Parameters:
**		qsc_ctx -- QMGR SMTPC context
**		id_val -- initial value
**
**	Returns:
**		SM_SUCCESS
*/

sm_ret_T
qsc_id_init(qsc_ctx_P qsc_ctx, uint32_t id_val)
{
	qsc_ctx->qsc_id_cnt = id_val;
	return SM_SUCCESS;
}

/*
**  QSC_ID_END -- end using session/transaction id counter for SMTPC
**
**	Parameters:
**		qsc_ctx -- QMGR SMTPC context
**
**	Returns:
**		SM_SUCCESS
*/

/* ARGSUSED0 */
sm_ret_T
qsc_id_end(qsc_ctx_P qsc_ctx)
{
	return SM_SUCCESS;
}

/*
**  QSC_ID_NEXT -- get next session/transaction id for SMTPC
**
**	Parameters:
**		qsc_ctx -- QMGR SMTPC context
**		daprocidx -- DA process idx
**		dathreadidx -- DA thread idx
**		id -- session/transaction id (output)
**
**	Returns:
**		SM_SUCCESS except for (un)lock errors
**
**	Side Effects: none on error (except if unlock fails)
*/

sm_ret_T
qsc_id_next(qsc_ctx_P qsc_ctx, uint daprocidx, uint dathreadidx, sessta_id_P id)
{
	uint idc;
#if SM_USE_SMTPC_MUTEX
	int r;

	r = pthread_mutex_lock(&(qsc_ctx->qsc_mutex));
	SM_LOCK_OK(r);
	if (r != 0)
		return sm_error_perm(SM_EM_Q_Q2SC, r);
#endif /* SM_USE_SMTPC_MUTEX */

	idc = qsc_ctx->qsc_id_cnt++;
	sm_snprintf(id, SMTP_STID_SIZE, SMTPC_STID_FORMAT,
			daprocidx, idc, dathreadidx);

#if SM_USE_SMTPC_MUTEX
	r = pthread_mutex_unlock(&(qsc_ctx->qsc_mutex));
	SM_ASSERT(r == 0);
	if (r != 0)
		return sm_error_perm(SM_EM_Q_Q2SC, r);
#endif /* SM_USE_SMTPC_MUTEX */
	return SM_SUCCESS;
}
