#!/bin/sh
# $Id: t-restart-1.sh,v 1.9 2005/07/18 22:24:01 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test restart functionality of mcp
# use transitive hull to restart several processes
# ----------------------------------------

test -s stop && exit 1

# set for verbose mode to -V...
V=""
ERRS=0
OUT=mcp.out
PIDS=pids
CONF=restart.conf
PIDF1="t-restart1.pid"
PIDF2="t-restart2.pid"
PIDF3="t-restart3.pid"
L1=restart.log
L2=restart2.log
L3=restart3.log
R1="restarts1"
R2="restarts2"
R3="restarts3"
VERBOSE=false
SD=`dirname $0`
. ${SD}/../check2/user.sh
if test $# -ge 1
then
  if test "X"$1 = "X-v"
  then
    VERBOSE=true;
  fi
fi

rm -f ${PIDS} ${OUT} ${PIDF1} ${PIDF2} ${PIDF3} ${L1} ${L2} ${L3}

cat > ${CONF} <<EOF
restart3 {
	start_action = wait;
	user = ${USER};
	path = ./t-restart;
	arguments = "t-restart -p ${PIDF3} -f ${R3} -n 2 -VV";
}

restart2 {
	start_action = wait;
	user = ${USER};
	restart_dependencies = {restart3};
	path = ./t-restart;
	arguments = "t-restart -p ${PIDF2} -f ${R2} -n 2 -VV";
}

restart {
	start_action = wait;
	user = ${USER};
	restart_dependencies = {restart2};
	path = ./t-restart;
	arguments = "t-restart -p ${PIDF1} -f ${R1} -n 3 -VV";
}

EOF

echo 0 > ${R1}
echo 0 > ${R2}
echo 0 > ${R3}
./mcp -t -dddd ${CONF} > ${OUT} 2>&1 &
echo $! >> ${PIDS}

i=0
while test ! -s ${PIDF1}
do
  sleep 3
  i=`expr ${i} + 1 `
  if test ${i} -ge 4
  then
    echo "$0: ERROR: missing ${PIDF1}"
    ERRS=`expr ${ERRS} + 1 `
    break
  fi
done

i=0
while grep 0 ${R1} > /dev/null
do
  sleep 1
  i=`expr ${i} + 1 `
  if test ${i} -ge 4
  then
    echo "$0: ERROR: ${R1} is not incremented"
    ${VERBOSE} && cat ${R1}
    ERRS=`expr ${ERRS} + 1 `
    break
  fi
done

i=0
while grep 0 ${R2} > /dev/null
do
  sleep 1
  i=`expr ${i} + 1 `
  if test ${i} -ge 4
  then
    echo "$0: ERROR: ${R2} is not incremented"
    ${VERBOSE} && cat ${R2}
    ERRS=`expr ${ERRS} + 1 `
    break
  fi
done

i=0
while grep 0 ${R3} > /dev/null
do
  sleep 1
  i=`expr ${i} + 1 `
  if test ${i} -ge 4
  then
    echo "$0: ERROR: ${R3} is not incremented"
    ${VERBOSE} && cat ${R3}
    ERRS=`expr ${ERRS} + 1 `
    break
  fi
done


CNT=2
if test -s ${PIDF1}
then
  PIDR=`cat ${PIDF1}`
  kill -HUP ${PIDR}
  sleep 5
  for F in ${R1} ${R2} ${R3}
  do
    if test -s ${F}
    then
      C=`cat ${F}`
      if test ${C} -ne ${CNT}
      then
        ${VERBOSE} && echo "counter ${F} wrong: got ${C}, expected ${CNT}"
        ERRS=`expr ${ERRS} + 1 `
      fi
    else
      ${VERBOSE} && echo "missing ${F}"
      ERRS=`expr ${ERRS} + 1 `
    fi
  done
fi

for i in `cat ${PIDS}`
do
  kill ${i}
done

exit ${ERRS}
