/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: rdwrcounter.c,v 1.1 2004/06/09 20:57:52 ca Exp $
 */

#include "sm/assert.h"

/*
**  rdwrcounter -- increment a counter in a file
**
**	Parameters:
**		prg -- name of program (of which this is part)
**		cntfn -- file name to use
**		pcur -- (pointer to) current value of counter (output)
**
**	Returns:
**		0 if ok, EX_USAGE otherwise
*/

static int
rdwrcounter(char *prg, char *cntfn, int *pcur)
{
	int i;
	FILE *cntfp;

	SM_ASSERT(prg != NULL);
	SM_ASSERT(cntfn != NULL);
	SM_ASSERT(pcur != NULL);

	/* get current invocation counter */
	cntfp = fopen(cntfn, "r");
	if (cntfp == NULL)
	{
		fprintf(stderr, "%s: can't open \"%s\" for reading %d\n",
			prg, cntfn, errno);
		return EX_USAGE;
	}
	i = fscanf(cntfp, "%d", pcur);
	if (i != 1)
		*pcur = 0;

	fclose(cntfp);
	cntfp = fopen(cntfn, "w");
	if (cntfp == NULL)
	{
		fprintf(stderr, "%s: can't open \"%s\" for writing %d\n",
			prg, cntfn, errno);
		return EX_USAGE;
	}

	/* increase invocation counter */
	fprintf(cntfp, "%d\n", *pcur + 1);
	fclose(cntfp);
	cntfp = NULL;
	return 0;
}
