/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-map-0.c,v 1.14 2004/12/22 18:45:02 ca Exp $")

#include "sm/error.h"
#include "sm/heap.h"
#include "sm/memops.h"
#include "sm/test.h"
#include "sm/maps.h"
#include "sm/mapc.h"
#include "sm/map.h"

#include "sm/io.h"

int Verbose = 0;

#define MAPC_TYPE	"bogus"
#define MAPC_NAME	"tmap"
#define MAPC_FILE	"./fmap"

static void
testh(void)
{
	sm_ret_T ret;
	sm_maps_P maps;
	sm_mapc_P mapc, mapc2;
	sm_map_P map;
	sm_cstr_P mtype, mname;

	maps = NULL;
	mapc = NULL;
	ret = sm_maps_init(&maps);
	SM_TEST(maps != NULL);
	if (maps == NULL)
		return;
	SM_TEST(sm_is_success(ret));

	mtype = sm_cstr_scpyn0((const uchar *)MAPC_TYPE, strlen(MAPC_TYPE));
	SM_TEST(mtype != NULL);
	if (mtype == NULL)
		goto error;

	mname = sm_cstr_scpyn0((const uchar *)MAPC_NAME, strlen(MAPC_NAME));
	SM_TEST(mname != NULL);
	if (mname == NULL)
		goto error;

	ret = sm_mapc_create(maps, mtype, 0, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, &mapc);
	SM_TEST(sm_is_success(ret));

	ret = sm_maps_find(maps, mtype, &mapc2);
	SM_TEST(sm_is_success(ret));

	map = NULL;
	ret = sm_map_open(maps, mname, mtype, 0, MAPC_FILE, 0, &map, SMPO_END);
	SM_TEST(sm_is_success(ret));

	/* perform some operations ... */


	ret = sm_map_close(map, 0);
	SM_TEST(sm_is_success(ret));

	ret = sm_maps_rm(maps, mapc);
	SM_TEST(sm_is_success(ret));
	ret = sm_maps_term(maps);
	SM_TEST(sm_is_success(ret));
	SM_CSTR_FREE(mtype);
	SM_CSTR_FREE(mname);
	return;

  error:
	sm_maps_term(maps);
}


int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "H:s:V")) != -1)
	{
		switch (c)
		{
		  default:
			return 1;
		}
	}
	sm_test_begin(argc, argv, "test map 0");
	testh();
	return sm_test_end();
}
