/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: maph.c,v 1.2 2004/08/25 18:23:53 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/maps.h"
#include "sm/mapc.h"
#include "sm/map.h"
#include "map.h"

/*
**  Maintain a list of available maps (by name).
**  Note: this reuses the map system hash table, hence a map MUST not
**	have the same name as a map type.
**	Enhancement: add a "tag" to the name, e.g., a non-printable character
**	to distinguish between map names and map types (typed symbol table).
*/

/*
**  SM_MAPNAME_ADD - add map (by name)
**
**	Parameters:
**		maps -- map system context
**		map -- map
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_mapname_add(sm_maps_P maps, sm_map_P map)
{
	sm_ret_T ret;
	bht_entry_P entry;

	SM_IS_MAPS(maps);
	SM_IS_MAP(map);
	ret = bht_add(maps->sm_maps_ht_map,
			(char *)sm_cstr_data(map->sm_map_name),
			sm_cstr_getlen(map->sm_map_name),
			map, &entry);
	return ret;
}

/*
**  SM_MAPNAME_RM - remove map (by name)
**
**	Parameters:
**		maps -- map system context
**		map -- map
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_mapname_rm(sm_maps_P maps, sm_map_P map)
{
	SM_IS_MAPS(maps);
	SM_IS_MAP(map);

	/* XXX check for existence and complain if it isn't registered? */
	bht_rm(maps->sm_maps_ht_map,
		(const char *)sm_cstr_data(map->sm_map_name),
		sm_cstr_getlen(map->sm_map_name), NULL, NULL);
	return SM_SUCCESS;
}

/*
**  SM_MAPNAME_FIND - lookup map by name
**
**	Parameters:
**		maps -- map system context
**		map_name -- map name
**		map -- (pointer to) map (output)
**
**	Returns:
**		pointer to value
*/

sm_ret_T
sm_mapname_find(sm_maps_P maps, const sm_cstr_P map_name, sm_map_P *pmap)
{
	void *ptr;

	SM_IS_MAPS(maps);
	SM_IS_CSTR(map_name);
	ptr = bht_find(maps->sm_maps_ht_map,
		(const char*)sm_cstr_data(map_name),
		sm_cstr_getlen(map_name));
	if (ptr == NULL)
		return sm_error_perm(SM_EM_MAP, ENOENT);
	if (pmap != NULL)
		*pmap = (sm_map_P)ptr;
	return SM_SUCCESS;
}

/*
**  SM_MAPNAME_FINDC - lookup map by name
**
**	Parameters:
**		maps -- map system context
**		map_name -- map name
**		map -- (pointer to) map (output)
**
**	Returns:
**		pointer to value
*/

sm_ret_T
sm_mapname_findc(sm_maps_P maps, const char *map_name, sm_map_P *pmap)
{
	void *ptr;

	SM_IS_MAPS(maps);
	SM_REQUIRE(map_name != NULL);
	ptr = bht_find(maps->sm_maps_ht_map, map_name, strlen(map_name));
	if (ptr == NULL)
		return sm_error_perm(SM_EM_MAP, ENOENT);
	if (pmap != NULL)
		*pmap = (sm_map_P)ptr;
	return SM_SUCCESS;
}
