/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: aq_rcpt_status.c,v 1.8 2005/09/21 17:42:51 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/actdb-int.h"
#include "sm/da.h"

/*
**  AQ_RCPT_STATUS2TXT -- Translate status into text
**
**	Parameters:
**		aq_rcpt -- AQ recipient
**		perrmsg -- (pointer to) error message (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
aq_rcpt_status2txt(aq_rcpt_P aq_rcpt, sm_str_P errmsg)
{
	sm_ret_T ret, rv;
	char *err_msg;

	SM_REQUIRE(errmsg != NULL);
	SM_IS_AQ_RCPT(aq_rcpt);
	rv = ret = SM_SUCCESS;
	err_msg = NULL;
	switch (aq_rcpt->aqr_status)
	{
	  case SMTP_OK:
		err_msg = "ok";
		break;
#ifdef SMTP_R_ACC
	  case SMTP_R_ACC:
		err_msg = "accept";
		break;
#endif
	  case SMTP_R_CONT:
		err_msg = "continue";
		break;
	  case SMTP_R_SSD:
		err_msg = "session shutting down";
		break;
	  case SMTP_R_TEMP:
		err_msg = "temporary error";
		break;
	  case SMTP_R_SYNTAX:
		err_msg = "syntax error";
		break;
	  case SMTP_R_REJECT:
		err_msg = "rejected";
		break;
	  case SMTPC_TEMP_ST:
		err_msg = "temporary error in DA";
		break;
	  case SMTPC_IO_ST:
		err_msg = "I/O error";
		break;
	  case SMTPC_DA_ST:
		err_msg = "lost DA [local error]";
		break;
	  case SMTPC_SE_OPEN_ST:
		err_msg = "session open error";
		rv = AQR_TXT_COMPLETE;
		break;
	  case SMTPC_SE_OP_TMO:
		err_msg = "session open: timeout";
		rv = AQR_TXT_COMPLETE;
		break;
	  case SMTPC_SE_OP_REFUSED:
		err_msg = "session open: connection refused";
		rv = AQR_TXT_COMPLETE;
		break;
	  case SMTPC_SE_OP_UNREACH:
		err_msg = "session open: host/net unreachable";
		rv = AQR_TXT_COMPLETE;
		break;
	  case SMTP_AR_TMO:
		err_msg = "timeout in address resolver";
		rv = AQR_TXT_COMPLETE;
		break;
	  case SMTP_AR_TEMP:
		err_msg = "temporary error in address resolver";
		rv = AQR_TXT_COMPLETE;
		break;
	  case SMTP_AR_ALIAS:
		err_msg = "alias expansion in address resolver failed";
		rv = AQR_TXT_COMPLETE;
		break;
	  case SMTP_CDB_TEMP:
		err_msg = "temporary error from CDB [local error]";
		break;
	  case SMTP_TMO_SCHED:
		err_msg = "timeout in scheduler [local error]";
		break;
	  case SMTP_TMO_DA:
		err_msg = "timeout waiting for DA";
		break;
	  case SMTP_AR_NOTF:
		err_msg = "address not found (address resolver)";
		break;
	  case SMTP_AR_PERM:
		err_msg = "permanent error (address resolver)";
		break;
	  case SMTP_AR_LOOP:
		err_msg = "CNAME loop (address resolver)";
		break;
	  case SMTP_AR_AL_REC:
		err_msg = "alias nesting too deep in address resolver";
		break;
	  case SMTP_AR_MXEMPTY:
		err_msg = "MX list empty in  address resolver, mail loops back";
		break;
	  case SMTPC_SE_TTMYSELF:
		err_msg = "talking to myself?";
		break;
	  default:
		if (smtp_is_reply_ok(aq_rcpt->aqr_status))
			err_msg = "ok";
		else if (smtp_is_reply_temp(aq_rcpt->aqr_status))
			err_msg = "temporary error";
		else if (smtp_is_reply_fail(aq_rcpt->aqr_status))
			err_msg = "permanent error";
	}
	if (err_msg != NULL)
		ret = sm_str_scat(errmsg, err_msg);
	return sm_is_err(ret) ? ret : rv;
}
