/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-greycnf-0.c,v 1.1 2005/08/01 17:58:19 ca Exp $")

#include "sm/error.h"
#include "sm/sysexits.h"
#include "sm/memops.h"
#include "sm/net.h"
#include <stdio.h>
#include "sm/greyctl.h"
#include "sm/greycnf.h"

#define SM_CONF_TIME_DEF 1
#define SM_GREYCNFDEF 1
#include "sm/greycnfdef.h"

static int
greyprtcnf(FILE *fp, greycnf_P greycnf)
{
	fprintf(fp,
		"limit=%u\n"
		"min_grey_wait=%u\n"
		"max_grey_wait=%u\n"
		"white_expire=%u\n"
		"white_reconfirm=%u\n"
		"main_DB_name=%s\n"
		"secondary_DB_name=%s\n"
		, greycnf->greycnf_limit
		, greycnf->greycnf_min_grey_wait
		, greycnf->greycnf_max_grey_wait
		, greycnf->greycnf_white_expire
		, greycnf->greycnf_white_reconfirm
		, greycnf->greycnf_grey_name
		, greycnf->greycnf_grey_sname
		);
	return 0;
}

static int
process(char const *name, FILE *fp, int show)
{
	sm_conf_T		*stream;
	int			err;
	char const *e = NULL;
	greycnf_T greycnf;
	char buf[SM_CONF_ERROR_BUFFER_SIZE];

	if (((stream = sm_conf_new(name ? name : "*stdin*"))) == NULL)
	{
		fprintf(stderr, "error -- sm_conf_new() returns NULL!\n");
		return 1;
	}
	if ((err = sm_conf_read_FILE(stream, name, fp)) != 0)
	{
		fprintf(stderr, "%s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 2;
	}

	sm_memzero(&greycnf, sizeof(greycnf));
	if ((err = sm_conf_scan(stream, greycnf_defs, 0, &greycnf)) != 0)
	{

		fprintf(stderr, "(while scanning) %s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 3;
	}

	greyprtcnf(stdout, &greycnf);

#if 0
	sm_conf_destroy(stream);
#endif /* 0 */

	return 0;
}

static void
usage(char *prg)
{
	fprintf(stderr,
		"%s: usage: %s [options] configfile\n"
		"options:\n"
		, prg, prg
		);
}


int
main(int argc, char **argv)
{
	int ai, c, ret;

	while ((c = getopt(argc, argv, "?D:d:F:f:hl:m:")) != -1)
	{
		switch (c)
		{
		  case 'f':
			ret = process(optarg, NULL, 0);
			if (ret != 0)
				return ret;
			break;
		  case '?':
		  case 'h':
		  default:
			usage(argv[0]);
			exit(EX_USAGE);
		}
	}
	argc -= optind;
	argv += optind;

	if (argc == 0)
		return process("*stdin*", stdin, 1);

	for (ai = 0; ai < argc; ai++)
	{
		int ret;

		ret = process(argv[ai], NULL, 1);
		if (ret != 0)
			return ret;
	}
	return 0;
}
