/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strsanitize.c,v 1.6 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/limits.h"
#include "sm/ctype.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_SANITIZE -- Replace control characters in str.
**
**	Parameters:
**		str -- sm_str_P object.
**
**	Returns:
**		number of modified characters
*/

uint
sm_str_sanitize(sm_str_P str)
{
	uint i;
	int c;
	uint n;

	SM_REQUIRE(str != NULL);
	n = 0;
	for (i = 0; i < sm_str_getlen(str); i++)
	{
		c = sm_str_rd_elem(str, i);
		if (!ISPRINT(c))
		{
			sm_str_wr_elem(str, i, '_');
			++n;
		}
	}
	return n;
}
