/*
 * Copyright (c) 2000-2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strresize.c,v 1.8 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/strrcb.h"
#include "sm/str-int.h"
#include "sm/str2rcb.h"

/*
**  SM_STR_RESIZE_DATA -- Resizes and resets str's internal data buffer.
**
**	Resizes str's internal data buffer to new_len, preserving old data.
**
**	Parameters:
**		str -- sm_str_P to resize.
**		new_len -- Total length of new buffer size.
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_RANGE
**
**	Side Effects: none on error.
**
**	Last code review: 2005-03-22 17:43:43
**	Last code change: 2005-03-22 17:40:32
*/

sm_ret_T
sm_str_resize_data(sm_str_P str, uint new_len)
{
	uchar *new_data;

	SM_REQUIRE(new_len > str->sm_str_size);
	if (new_len > str->sm_str_max)
		return sm_error_perm(SM_EM_STR_RCB, SM_E_RANGE);

	/* question: use realloc?? */
	new_data = sm_rpool_malloc(str->sm_str_rpool, new_len);
	if (new_data == NULL)
		return sm_error_perm(SM_EM_STR_RCB, ENOMEM);
	sm_memcpy((void *)new_data, str->sm_str_base, str->sm_str_len);
	sm_rpool_free_size(str->sm_str_rpool, str->sm_str_base,
			str->sm_str_size);
	str->sm_str_base = new_data;
	str->sm_str_size = new_len;
	return SM_SUCCESS;
}
