/*
 * Copyright (c) 2000-2002, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fwrite.c,v 1.9 2005/03/15 19:56:07 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"
#include "fvwrite.h"

/*
**  SM_IO_WRITE -- write to a file pointer
**
**	Parameters:
**		fp -- file pointer writing to
**		buf -- location of data to be written
**		size -- number of bytes to be written
**		byteswritten -- number of bytes actually written
**
**	Result:
**		usual sm_error code
*/

sm_ret_T
sm_io_write(sm_file_T *fp, const uchar *buf, size_t size, ssize_t *byteswritten)
{
	sm_ret_T res;
	struct sm_uio uio;
	struct sm_iov iov;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);

	if (f_write(*fp) == NULL)
		return sm_error_perm(SM_EM_IO, ENODEV);

	iov.iov_base = (void *) buf;
	uio.uio_resid = iov.iov_len = size;
	uio.uio_iov = &iov;
	uio.uio_iovcnt = 1;

	res = sm_fvwrite(fp, &uio);
	*byteswritten = size - uio.uio_resid;
	if (*byteswritten > 0 && sm_is_temp_err(res))
		return SM_SUCCESS;
	if (sm_is_err(res))
		return res;

	/* fixme: This loses warnings etc, maybe just return res?? */
	return SM_SUCCESS;
}
