/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fputstr.c,v 1.2 2002/05/09 16:35:30 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "io-int.h"
#include "fvwrite.h"

/*
**  SM_IO_FPUTSTR -- add a str to the buffer for the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		str -- str to be placed in the buffer
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fputstr(sm_file_T *fp, const sm_str_P s)
{
	sm_uio_T uio;
	sm_iov_T iov;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	iov.iov_base = (void *) sm_str_getdata(s);
	iov.iov_len = uio.uio_resid = sm_str_getlen(s);
	uio.uio_iov = &iov;
	uio.uio_iovcnt = 1;
	return sm_fvwrite(fp, &uio);
}
