/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: edbcrmentry.c,v 1.6 2005/04/01 18:47:18 ca Exp $")
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "sm/edbc.h"
#include "edbc.h"
#include "sm/qmgrdbg.h"

/*
**  EDBC_RMENTRY -- remove entry with rcpt_id
**
**	Parameters:
**		edbc_ctx -- edbc context
**		rcpt_id -- Recipient Id
**
**	Returns:
**		usual sm_error code; SM_E_NOTFOUND
**
**	Locking: must be performed by caller.
**
**	Last code review: 2005-04-01 17:57:16
**	Last code change: 2005-04-01 17:51:12
*/

sm_ret_T
edbc_rmentry(edbc_ctx_P edbc_ctx, rcpt_id_T rcpt_id)
{
	edbc_tnode_P edbc_tnode;
	edbc_node_P edbc_node, edbc_node_nxt;

	SM_REQUIRE(edbc_ctx != NULL);
	edbc_tnode = RB_MIN(edbc_tree_S, &(edbc_ctx->edbc_root));
	while (edbc_tnode != NULL)
	{
		for (edbc_node = ECNL_FIRST(&(edbc_tnode->ectn_hd));
		     edbc_node != ECNL_END(&(edbc_tnode->ectn_hd));
		     edbc_node = edbc_node_nxt)
		{
			edbc_node_nxt = ECNL_NEXT(edbc_node);
			if (RCPT_ID_EQ(edbc_node->ecn_rcpt_id, rcpt_id))
			{
				ECNL_REMOVE(&(edbc_tnode->ectn_hd), edbc_node);
				SM_FREE_SIZE(edbc_node, sizeof(*edbc_node));
				if (ECNL_EMPTY(&(edbc_tnode->ectn_hd)) &&
				    RB_REMOVE(edbc_tree_S,
						&(edbc_ctx->edbc_root),
						edbc_tnode) != NULL)
				{
					SM_FREE_SIZE(edbc_tnode,
						sizeof(*edbc_tnode));
				}
				SM_ASSERT(edbc_ctx->edbc_entries > 0);
				--edbc_ctx->edbc_entries;
				return SM_SUCCESS;
			}
		}
		edbc_tnode = RB_NEXT(edbc_tree_S, &(edbc_ctx->edbc_root),
					edbc_tnode);
	}
	return sm_error_temp(SM_EM_Q_EDBC, SM_E_NOTFOUND);
}
