#!/bin/sh
# $Id: t-conf-sock-0.sh,v 1.4 2005/08/15 23:32:38 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

# ------------------------------------------------------------
# test socket specifications; uses t-conf-sock-0
# ------------------------------------------------------------

test -s stop && exit 1

# source directory of this (and other) shell script
SD=`dirname $0`

ERRS=0

CNF=sms0.conf
OUT=sms0.out
OK=sms0.ok

PRG=./t-conf-sock-0

cat > ${CNF} <<EOF
listen_socket { type=unix; path="/a/b/path.sock";}
EOF
cat > ${OK} <<EOF
path="/a/b/path.sock"
EOF
if ${PRG} ${CNF} 2>&1 | grep '^path' >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
listen_socket { type=inet; port=23; address=1.2.3.4;}
EOF
cat > ${OK} <<EOF
port=23
address= 1.2.3.4
EOF
if ${PRG} ${CNF} >${OUT} 2>&1
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

cat > ${CNF} <<EOF
listen_socket { type=inet; port=123; address=11.22.33.44;}
EOF
cat > ${OK} <<EOF
port=123
address= 11.22.33.44
EOF
if ${PRG} ${CNF} 2>&1 >${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

# input not correct: generate error
cat > ${CNF} <<EOF
listen_socket { port=123; address=11.22.33.44;}
EOF
cat > ${OK} <<EOF
(while scanning) sms0.conf: invalid value
sms0.conf:1: can't determine type of multiple-choice object
EOF
if ${PRG} ${CNF} >${OUT} 2>&1
then
  ERRS=`expr ${ERRS} + 1 `
else
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
fi

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
