/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm-conf-type-char.c,v 1.4 2005/05/24 17:57:28 ca Exp $")


#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/memops.h"
#include "sm/sm-conf.h"
#endif /* SM_LIBCONF_ALONE */

#include "sm-conf-type.h"
#include "sm-conf-state.h"

static int
sm_conf_type_char_node_to_value(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	sm_conf_node_T			*node,
	void				*data)
{
	char const			*text;
	size_t				text_n;
	int				err;

	SM_IS_CONF_DEF(def);
	err = 0;
	if (def->scd_flags & SM_CONF_FLAG_MULTIPLE)
	{
		/* XXX */
	}
	else
	{
		err = sm_conf_node_to_value(smc, "char",
			node, &text, &text_n);
		if (err != 0)
			return err;

		if (strlen(text) != 1 || text_n != 1)
		{
			char loc[SM_CONF_ERROR_BUFFER_SIZE];
			sm_conf_error_add(smc,
				"%s: expected one char in %s '%.*s'",
				sm_conf_node_location(smc, node,
					loc, sizeof loc),
				def->scd_name[0] == '\0'
					? "char" : def->scd_name,
				(int)text_n, text);
			return SM_CONF_ERR_TYPE;
		}

		if (data != NULL)
			*(unsigned char *)data = *(unsigned char *)text;
	}
	return err;
}

static int
sm_conf_type_char_value_check(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	void const			*data)
{
	SM_IS_CONF_DEF(def);

	/* if we have a check function, use it. */
	if (def->scd_check != NULL)
		return (* def->scd_check)(smc, def->scd_check_data, def, data);
	return 0;
}

static int
sm_conf_type_char_value_null(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	void				*data)
{
	if (data == NULL)
		return 0;

	SM_IS_CONF_DEF(def);
	*(unsigned char *)data = *(unsigned char *)def->scd_default;
	return 0;
}

sm_conf_type_T const
sm_conf_type_char_data =
{
	sm_conf_type_char_node_to_value,
	sm_conf_type_char_value_check,
	sm_conf_type_char_value_null
};
