/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: scanner.c,v 1.6 2005/01/27 00:31:03 ca Exp $")

#if SM_LIBCONF_ALONE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sm-conf.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/string.h"
#include "sm/sm-conf.h"
#include <stdio.h>
#endif /* SM_LIBCONF_ALONE */

/* SCANNER.C -- demo sm_conf_scan() */

#ifndef offsetof
#define offsetof(type, member)	((char *)&((type *)0)->member - (char *)0)
#endif

typedef struct
{
	unsigned short	short_u32;
} structure;

sm_conf_definition_T
definitions[] = {

	{ SM_CONF_DEF_MAGIC, "short_u32",
		sm_conf_type_u32,
		offsetof(structure, short_u32),
		sizeof(structure),
		"42"
	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL },
};

static void
dump_structure(structure *s)
{
	printf("short_u32: %hu\n", s->short_u32);
}

static int
process(char const *name, FILE *fp)
{
	sm_conf_T	*stream;
	int		err;
	structure	s;

	if (((stream = sm_conf_new(name ? name : "*stdin*"))) == NULL)
	{
		fprintf(stderr, "error -- sm_conf_new() returns NULL!\n");
		return 1;
	}
	if ((err = sm_conf_read_FILE(stream, name, fp)) != 0)
	{
		char buf[SM_CONF_ERROR_BUFFER_SIZE];
		char const *e = NULL;

		fprintf(stderr, "%s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 2;
	}

	err = sm_conf_scan(stream, definitions, 0, &s);
	if (err)
	{
		char buf[SM_CONF_ERROR_BUFFER_SIZE];
		char const *e = NULL;

		fprintf(stderr, "%s: %s\n",
			name ? name : "*stdin*",
			sm_conf_strerror(err, buf, sizeof buf));

		while ((e = sm_conf_syntax_error(stream, e)) != NULL)
			fprintf(stderr, "%s\n", e);

		sm_conf_destroy(stream);
		return 3;
	}
	else
		dump_structure(&s);

	sm_conf_destroy(stream);
	return 0;
}

int
main(int ac, char **av)
{
	int	ret;
	int	ai;

	ret = 0;
	if (ac == 1)
		ret = process("*stdin*", stdin);
	else
	{
		for (ai = 1; ai < ac; ai++)
		{
			ret = process(av[ai], NULL);
			if (ret != 0)
				break;
		}
	}

	return ret;
}
