/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-cdb-0.c,v 1.8 2005/04/14 17:19:29 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/io.h"
#include "sm/sysexits.h"
#include "sm/cdb.h"
#include "sm/test.h"

#define SM_BUF_SIZE	(4 * 1024)

/*
**  CDB_TEST -- simple CDB test
**
**	Parameters:
**		base -- base name for CDB
**
**	Returns:
**		usual sm_error code
*/

static sm_ret_T
cdb_test(char *base)
{
	size_t i;
	sm_ret_T ret;
	cdb_ctx_P cdb_ctx;
	sm_file_T *dfp;
	ssize_t byteswritten, bytesread;
	sessta_id_T ta_id;
	uchar wbuf[SM_BUF_SIZE], rbuf[SM_BUF_SIZE];

	dfp = NULL;
	SM_ASSERT(sizeof(rbuf) == sizeof(wbuf));
	ret = cdb_start(base, &cdb_ctx);
	SM_TEST(ret == SM_SUCCESS);
	if (sm_is_err(ret))
		return ret;

	for (i = 0; i < sizeof(wbuf); i++)
	{
		wbuf[i] = 'A' + (i % 32);
		if (i % 78 == 0)
			wbuf[i] = '\n';
	}

	sm_snprintf(ta_id, sizeof(ta_id), SMTPS_STID_FORMAT,
		(ulonglong_T) 1, 2);

	ret = cdb_open(cdb_ctx, ta_id, dfp,
			SM_IO_WREXCL, /*size*/ 0, /*hints*/ 0);
	SM_TEST(ret == SM_SUCCESS);
	if (sm_is_err(ret))
		goto end;

	/* write some stuff ... */
	ret = cdb_write(cdb_ctx, dfp, (uchar *) wbuf, sizeof(wbuf),
			&byteswritten);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(byteswritten == sizeof(wbuf));

	ret = cdb_close(cdb_ctx, dfp);
	SM_TEST(ret == SM_SUCCESS);

	/* fails, file exists */
	ret = cdb_open(cdb_ctx, ta_id, dfp,
			SM_IO_WREXCL, /*size*/ 0, /*hints*/ 0);
	SM_TEST(ret != SM_SUCCESS);
	if (!sm_is_err(ret))
	{
		cdb_close(cdb_ctx, dfp);
		goto end;
	}

	/* try to read */
	ret = cdb_open(cdb_ctx, ta_id, dfp,
			SM_IO_RDONLY, /*size*/ 0, /*hints*/ 0);
	SM_TEST(ret == SM_SUCCESS);

	ret = sm_io_read(dfp, rbuf, sizeof(rbuf), &bytesread);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(bytesread == sizeof(rbuf));

	for (i = 0; i < sizeof(rbuf); i++)
	{
		SM_TEST(wbuf[i] == rbuf[i]);
		if (wbuf[i] != rbuf[i])
			break;
	}

	ret = cdb_close(cdb_ctx, dfp);
	SM_TEST(ret == SM_SUCCESS);

	ret = cdb_unlink(cdb_ctx, ta_id);
	SM_TEST(ret == SM_SUCCESS);

  end:
	ret = cdb_end(cdb_ctx);
	SM_TEST(ret == SM_SUCCESS);

	return ret;
}

/*
**  USAGE -- usage message
**
**	Parameters:
**		prg -- program name
**
**	Returns:
**		none
*/

static void
usage(char *prg)
{
	sm_io_fprintf(smioerr, "usage: %s [options]\n"
		"perform CDB checks\n"
		"-b name  set base of CDB directory, default: empty\n"
		"         must be empty [= current directory] or end in '/'\n"
		, prg
		);
	return;
}

int
main(int argc, char *argv[])
{
	int c;
	char *base;

	base = "";
	while ((c = getopt(argc, argv, "b:")) != -1)
	{
		switch (c)
		{
		  case 'b':
			base = strdup(optarg);
			SM_TEST(base != NULL);
			if (base == NULL)
				return EX_OSERR;
			break;
		  default:
			usage(argv[0]);
			return EX_USAGE;
		}
	}

	sm_test_begin(argc, argv, "test cdb 0");
	cdb_test(base);
	return sm_test_end();
}
