/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: ssdef.h,v 1.28 2005/10/19 18:49:26 ca Exp $
 */

#ifndef SM_SSDEF_H
#define SM_SSDEF_H 1

#include "sm/generic.h"
#include "sm/units.h"

/* policy milter: turned off by default */
#ifndef SM_USE_PMILTER
# define SM_USE_PMILTER	0
#endif

/* SMTP Server Context configuration flags */
#define SSC_CFL_ACCESS_DB	0x00000001u /* use access map */
#define SSC_CFL_DELAY_CHKS	0x00000002u /* delay checks */
#define SSC_CFL_SPAM_FRIEND	0x00000004u /* spam friend feature */
#define SSC_CFL_SPAM_HATER	0x00000008u /* spam hater feature */
#define SSC_CFL_8BITMIME	0x00000010u /* offer 8BITMIME */
#define SSC_CFL_BACKGROUND	0x00000020u /* fork */
#define SSC_CFL_SERIAL_ACC	0x00000040u /* serialize accept */
#define SSC_CFL_SOFTBOUNCE	0x00000080u /* softbounce (replace 5xy with 4xy) */

/* do not consider lmtp: in mt as local wrt relaying */
#define SSC_CFL_LMTPNOTRELAY	0x00000100u

/* protected recipients options */
#define SSC_CFL_PROTBYMAIL	0x00000200u /* allow access by sender (MAIL) */
#define SSC_CFL_PROTBYCLTADDR	0x00000400u /* allow access by client (IPv4) */
/* use string map for protected recipient lookups */
#define SSC_CFL_PROTMAP		0x00000800u

/* match user+detail against user too */
#define SSC_CFL_PROTIMPLDET	0x00001000u

/* pmfilter related options */
#define SSC_CFL_PMILTER		0x00002000u /* use policy milter */

/* #define SSC_CFL_CHK_EHLO	0x00004000u * check EHLO again access map */
#define SSC_CFL_EHLO_CHECKS	0x00008000u /* strict EHLO syntax check */

/* STARTTLS related options */
#define SSC_CFL_TLS_REL_VRFY	0x00010000u /* allow relaying if verified */
#define SSC_CFL_TLS_REL_ACC	0x00020000u /* check access map for relaying */

/* match user+detail against user too */
#define SSC_CFL_ACCIMPLDET	0x00040000u

#define SSC_CFL_GREY		0x00080000u /* turn on greylisting */

/* return greylisting error after DATA */
#define SSC_CFL_GREY_DATA	0x00100000u

/* require EHLO/HELO */
#define SSC_CFL_EHLO_REQ	0x00200000u

/* what should be done if pmilter fails? */
#define SSC_MFL_PM_421		0x00000001u /* 421 ... */
#define SSC_MFL_PM_AGAIN	0x00000002u /* accept but try to reconnect */
/* #define SSC_MFL_PM_IGN	0x00000004u * ignore failure: default */
/* #define SSC_MFL_PM_TEMP	0x00000008u * tempfail everything */

/* Socket listen queue size */
#define LISTENQ_SIZE_DEFAULT 256

/* SMAR reply read timeout (in seconds) */
#define TMO_W4A2S	20

/* QMGR reply read timeout (in seconds) (too long?) */
#define TMO_W4Q2S	20

/* Milter reply read timeout (in seconds) */
#define TMO_W4M2S	20

/*
**  I/O with SMTP client
**  RFC 2821:
**    An SMTP server SHOULD have a timeout of at least 5 minutes while it
**    is awaiting the next command from the sender.
*/

#define SS_IO_TIMEOUT 300

/* max. number of Received: headers (hops) */
#define SM_MAXHOPS 21

/* max. message size */
#define SM_MAX_MSG_SZ_KB	64 UNIT_MB

#define RELAY_CLT "127.0.0.1"
#define RELAY_RCPT "(^<postmaster>|@localhost>)$"

/* for testing, increase later on? */
#define SS_SESS_MAX_BADCMDS	3
#define SS_SESS_MAX_NOPCMDS	5
#define SS_SESS_MAX_INVLDADDR	200

#define SS_TA_MAX_BADCMDS	3
#define SS_TA_MAX_NOPCMDS	5
#define SS_TA_MAX_INVLDADDR	100

#endif /* SM_SSDEF_H */
