/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: sscnf.h,v 1.31 2005/10/25 23:33:40 ca Exp $
 */

#ifndef SSCNF_H
#define SSCNF_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/time.h"
#include "sm/io.h"
#include "sm/sm-conf.h"
#include "sm/logcnfdef.h"
#include "sm/mcpcnfs.h"

#ifndef SS_LOGDIR
#define SS_LOGDIR	0
#endif

/* Max number of listening sockets ("hardware virtual servers") */
#define SS_MAX_BIND_ADDRS 16

/* SMTPS configuration context */
typedef struct ss_cnf_S		ss_cnf_T, *ss_cnf_P;
struct ss_cnf_S
{
#if 0
	sm_magic_T	 sm_magic;
#endif
	sm_conf_T	*ss_cnf_smc;		/* parsed configuration */
	char		*ss_cnf_conffile;	/* name of configuration file */
	char		*ss_cnf_section;	/* name of section to use */
	char		*ss_cnf_smtpssock;	/* SMTP Server/QMGR socket */
	char		*ss_cnf_smarsock;	/* SMAR socket */
	char		*ss_cnf_cdb_base;	/* Base name for CDB */
	char		*ss_cnf_fd_socket; /* socket over which fd is passed */
	char		*ss_cnf_hostname;

	char		*ss_cnf_relay_to;
	char		*ss_cnf_relay_from;

#if SS_LOGDIR
	char		*ss_cnf_logdir;
#endif
	uint		 ss_cnf_loglevel;
	sm_logspec_T	 ss_cnf_log;

	gid_t		 ss_cnf_cdb_gid;
	sm_intvl_T	 ss_cnf_timeout;	/* timeout for I/O */
	uint		 ss_cnf_wait4srv;

	uint		 ss_cnf_w4a2s;	/* wait for reply from smar */

	int		 ss_cnf_listenq_size;
	uint		 ss_cnf_maxhops;
	uint		 ss_cnf_debug;

	uint		 ss_cnf_max_msg_sz_kb;

	uint		 ss_cnf_id_base; /* smtps base id (before fork() */
	uint		 ss_cnf_id;	/* smtps id */

	/* limits (global, could be set per session or maybe transaction) */
	uint		 ss_cnf_t_tot_lim; /* number of transaction total */
	uint		 ss_cnf_r_tot_lim; /* number of recipients total */
	uint		 ss_cnf_r_ta_lim; /* number of recipients per TA */
#if 0
	/* not yet checked nor counted */
	uint		 ss_cnf_r_fail_lim; /* number of failed recipients */
	uint		 ss_cnf_r_ok_lim;	/* number of recipients ok */
#endif

	/* max number of bad commands per session */
	uint		 ss_cnf_sess_max_badcmds;
	uint		 ss_cnf_sess_max_nopcmds;
	uint		 ss_cnf_sess_max_invldaddr;
	uint		 ss_cnf_ta_max_badcmds;
	uint		 ss_cnf_ta_max_nopcmds;
	uint		 ss_cnf_ta_max_invldaddr;

	uint32_t	 ss_cnf_cflags;

#if 0
	int		 ss_cnf_port;
#endif
	int		 ss_cnf_vp_count; /* Number of server processes (VPs) */

	/*
	**  Thread throttling parameters (all numbers are per listening socket).
	**  Zero values mean use default.
	*/

	uint		 ss_cnf_max_threads;

	/* Max number of "spare" threads */
	uint		 ss_cnf_max_wait_threads;

	/* Min number of "spare" threads */
	uint		 ss_cnf_min_wait_threads;

	int		 ss_cnf_sk_count;
	char		*ss_cnf_sck_addr[SS_MAX_BIND_ADDRS];

#if SM_USE_TLS
	char		*ss_cnf_cert;
	char		*ss_cnf_key;
	char		*ss_cnf_dsa_cert;
	char		*ss_cnf_dsa_key;
	char		*ss_cnf_certpath;
	char		*ss_cnf_cacert;

	char		*ss_cnf_cert_abs;
	char		*ss_cnf_key_abs;
	char		*ss_cnf_dsa_cert_abs;
	char		*ss_cnf_dsa_key_abs;
	char		*ss_cnf_certpath_abs;
	char		*ss_cnf_cacert_abs;
#endif /* SM_USE_TLS */

#if SM_USE_SASL
	uint32_t	 ss_cnf_auth_flags;
	char		*ss_cnf_trusted_mechs;
#endif
#if SM_USE_PMILTER
	sockspec_T	 ss_cnf_miltsockspec;
	uint32_t	 ss_cnf_mflags;	/* flags */
	uint		 ss_cnf_w4m2s;
	/* XXX options? timeout, error behavior, list of macros, others? */
#endif /* SM_USE_PMILTER */
	MCP_STRUCTS(ss_cnf_T, ss_cnf)
};

void ss_prt_cnf(ss_cnf_P ss_cnf, sm_file_T *fp, bool _all);

#endif /* SSCNF_H */
