/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sockcnf.h,v 1.2 2005/08/24 20:54:09 ca Exp $
 */

#ifndef SM_SOCKCNF_H
#define SM_SOCKCNF_H 1

#include "sm/generic.h"
#include "sm/net.h"

enum sock_type_E
{
	SOCK_TYPE_UNIX	= 1,
	SOCK_TYPE_INET	= 2,
	SOCK_TYPE_INET6	= 3
};

typedef enum sock_type_E sock_type_T;

typedef struct sockspec_U sockspec_T, *sockspec_P;

struct sockspec_U
{
	sock_type_T		 sckspc_type;

	struct
	{
		sock_type_T	 unixsckspc_type;
		char		*unixsckspc_path;

		/* umask for socket creation */
		mode_t		 unixsckspc_umask;

		/* socket owner: user name */
		char		*unixsckspc_user;

		/* socket owner: group name */
		char		*unixsckspc_group;
	} sock_unix;

	struct
	{
		sock_type_T	 inetsckspc_type;
		int		 inetsckspc_port;
		ipv4_T		 inetsckspc_addr;
	} sock_inet;
};
#endif /* SM_SOCKCNF_H */
