/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: qmgrdbg.h,v 1.16 2005/09/19 05:36:45 ca Exp $
 */

#ifndef SM_QMGRDBG_H
#define SM_QMGRDBG_H 1

#include "sm/generic.h"
#include "sm/qmgrcto.h"

#if QMGR_DEBUG
#include "sm/io.h"

#define QMGR_DEBUG_CATS	32	/* maximum number of debug categories */

/* synchronize this with qmgr/log.h: QM_LMOD_ */
#define QDC_GENERIC	0	/* default if nothing else is specified */
#define QDC_INIT	1
#define QDC_START	2
#define QDC_STOP	3
#define QDC_S2Q		4	/* SMTPS to QMGR */
#define QDC_Q2S		5	/* QMGR to SMTPS */
#define QDC_C2Q		6	/* SMTPC to QMGR */
#define QDC_Q2C		7	/* QMGR to SMTPC */
#define QDC_A2Q		8	/* SMAR to QMGR */
#define QDC_Q2A		9	/* QMGR to SMAR */
#define QDC_SCHED	10
#define QDC_UPDRCPT	11
#define QDC_BOUNCE	12
#define QDC_CLEANUP	13
#define QDC_RSRC	14
#define QDC_EDBR	15
#define QDC_EDBS	16
#define QDC_EDBC	17
#define QDC_IQDB	18
#define QDC_IBDB	19
#define QDC_CTL2Q	20	/* CTL to QMGR */
#define QDC_WKSCHED	21	/* wakeup scheduler */
#define QDC_IBDBR	22
#define QDC_OCC		23
/* #define QDC_DADB	24 */

/* check whether last number is too big */
#if QDC_IBDBR >= QMGR_DEBUG_CATS
 ERROR: QDC_IBDBR_ >= QMGR_DEBUG_CATS_
#endif

#if QMGR_DEBUG_DEFINE
uint qm_debug[QMGR_DEBUG_CATS];
#else
extern uint qm_debug[QMGR_DEBUG_CATS];
#endif

# define QM_DEBFP	smioerr
# define QM_LEV_DPRINTF(lev, x)	do			\
	{						\
		if ((lev) < qm_debug[0])		\
			sm_io_fprintf x;		\
	} while (0)

# define QM_LEV_DPRINTFC(cat, lev, x)	do		\
	{						\
		if ((lev) < qm_debug[cat])		\
			sm_io_fprintf x;		\
	} while (0)

# define QM_LEV_DPRINTFCT(cat, lev, x, tv)	do	\
	{						\
		if ((lev) < qm_debug[cat])		\
		{					\
			sm_io_fprintf(QM_DEBFP, "%ld.%06ld: ", (tv).tv_sec, (tv).tv_usec);	\
			sm_io_fprintf x;		\
		}					\
	} while (0)


/* XXX This is ugly since it references QM_DEBFP */
# define QM_LEV_DPRINTT(lev, x, tv)	do		\
	{						\
		if ((lev) <= qm_debug[0])		\
		{					\
			sm_io_fprintf(QM_DEBFP, "%ld.%06ld: ", (tv).tv_sec, (tv).tv_usec);	\
			sm_io_fprintf x;		\
		}					\
	} while (0)

# define QM_LEV_DPRINTTC(cat, lev, x, tv)	do	\
	{						\
		if ((lev) <= qm_debug[cat])		\
		{					\
			sm_io_fprintf(QM_DEBFP, "%ld.%06ld: ", (tv).tv_sec, (tv).tv_usec);	\
			sm_io_fprintf x;		\
		}					\
	} while (0)

# define QM_DPRINTF(x)	sm_io_fprintf x
#else /* QMGR_DEBUG */
# define QM_DPRINTF(x)
# define QM_LEV_DPRINTF(lev, x)
# define QM_LEV_DPRINTT(lev, x, tv)
# define QM_LEV_DPRINTFC(cat, lev, x)
# define QM_LEV_DPRINTTC(cat, lev, x, tv)
#endif /* QMGR_DEBUG */


#if QMGR_DEBUG > 1
void	 aq_rcpt_print(aq_rcpt_P _aq_rcpt);
void	 aq_ta_print(aq_ta_P _aq_ta);
#endif

#endif /* SM_QMGRDBG_H */
