/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: batvcnf.h,v 1.2 2005/01/31 21:25:17 ca Exp $
 */

#ifndef SM_BATVCNF_H
#define SM_BATVCNF_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/types.h"

#define BATV_MAX_KEYS	10

typedef struct batv_key_S	batv_key_T, *batv_key_P;
struct batv_key_S
{
	sm_magic_T	 sm_magic;
	uint32_t	 batv_key_number;
	char		*batv_priv_key;
};

typedef struct batv_cnf_S	batv_cnf_T, *batv_cnf_P;
struct batv_cnf_S
{
	sm_magic_T	 sm_magic;
	uchar		 batvcnf_delim;
	uint		 batvcnf_timeout;
	uint		 batvcnf_flags;
	uint		 batvcnf_n;
	batv_key_T	 batvcnf_keys[BATV_MAX_KEYS];
};

#endif /* SM_BATVCNF_H */
