#!/bin/sh
# $Id: t-smtpe-1.sh,v 1.8 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test permanent failure from SMTP sink for all recipients;
# trigger an error in bounce handling
# uses smtp1.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
SKIP=""
VERBOSE=false
EDBROK="../qmgr/t-smtpe-1.ok"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

if ./qmgr -VVV 2>/dev/null | ${GREP} QMGR_TEST >/dev/null
then
  :
else
  echo "$0: qmgr not compiled with QMGR_TEST; test SKIPPED"
  exit 0
fi

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
s1-0: local:
s1-1: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# run some test programs

TEST=1
# ----------------------------------------
# permanent failure from SMTP for all recipients
# trigger error in bounce handling:
# define QMGR_TEST_UPD_DSN	0x00000004
# edb_rcpt_rm_req() fails in qda_upd_dsn()
# this causes a shutdown of qmgr

if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<s1-0@local.dom>
	rcpts_tot=2
	rcpts_left=1
	rcpts_temp=0
	rcpts_perm=1
	state=550
	aqt_rcpts_ar=0
got recipient
	rcpt=<550@local.host>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=550
EOF
if ${SHELL} ${SD}/smtp1.sh -v 10 -E 1 -Q '-D 4 -M 16 -t 4' -z q -O ${EDBROK} -3 lmtpsock -Ss1-0@local.dom -R550@local.host
then
ls lmtpdir/?/S* ?/S*
  if test -s ${B1}
  then
    # check content of ${B1}?

    if ${GREP} 'sev=ERROR, func=qm_fr_sc_react,' q0.log >/dev/null
    then
      # make space for next test
      rm -f ${B1}

      if ${VERBOSE}
      then
          ../checks/t-edbr-1 -VVV
          ../libibdb/t-idbr-1
          ls ?/S*
      fi

      # run MTS again to retry delivery
      if ${SHELL} ${SD}/smtp1.sh -DIM -s 20 -v 10 -E 1 -3 lmtpsock -Ss1-1@local.dom -Rrcpt2@local.host
      then
        test -s ${B1} || ERR=true
      else
        ERR=true
      fi

    else
      ERR=true
    fi
  else
    ERR=true
  fi
else
  ERR=true
fi

if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
