#!/bin/sh
# $Id: t-pmilter-6.sh,v 1.9 2005/10/19 18:34:53 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test pmilter: get macros from MTA
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

OUT="t-pmilter-6.out"
MSG="t-pmilter-6.msg"
PMPRG="-p ../libpmilter/t-pmilter-1"
PMOPT=""

if test X"`uname`" != "XOSF1"
then
while getopts O:p:s:V FLAG
do
  case "${FLAG}" in
    O) PMOPT="${PMOPT} ${OPTARG}";;
    p) PMPRG="-p ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=2; }
}
EOF
${CAT} > ${MSG} <<EOF
From: sender@local.domain
To: rcpt@local.domain
Message-Id: <123456789@local.dom>
Subject: test msg-id

123456789@local.dom
EOF

# ----------------------------------------
# get hostname macro
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-m H" -Z 'smtpc2' -c '-E' -E 1 -A 1 -X 1 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
    if ${GREP} 'srvhostname=' ${PML} | ${GREP} -v 'srvhostname=(null)' >/dev/null
    then
      if ${GREP} -i 'err' ${PML} >/dev/null
      then
        ERR=true
      fi
    else
      ERR=true
    fi
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# get message-id macro
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-m M" -Z 'smtpc2' -c "-E -D ${MSG}" -E 1 -A 1 -X 1 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
    if ${GREP} 'msgid=<123456789@local.dom>' ${PML} >/dev/null
    then
      if ${GREP} -i 'err' ${PML} >/dev/null
      then
        ERR=true
      fi
    else
      ERR=true
    fi
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# get session-id macro
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-m S" -Z 'smtpc2' -c "-E" -E 1 -A 1 -X 1 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
    if ${GREP} 'se_id=' ${PML} | ${GREP} -v 'se_id=(null)'  >/dev/null
    then
      if ${GREP} -i 'err' ${PML} >/dev/null
      then
        ERR=true
      fi
    else
      ERR=true
    fi
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# get transaction-id macro
TEST=4
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-m T" -Z 'smtpc2' -c "-E" -E 1 -A 1 -X 1 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
    if ${GREP} 'ta_id=' ${PML} | ${GREP} -v 'ta_id=(null)'  >/dev/null
    then
      if ${GREP} -i 'err' ${PML} >/dev/null
      then
        ERR=true
      fi
    else
      ERR=true
    fi
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# get message-id macro but make sure it is not set on 2nd ta during mail
TEST=5
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh ${PMPRG} ${PMOPT} -P "-m M -2" -Z 'smtpc2' -c "-E -D ${MSG}" -T 2 -E 2 -A 2 -X 2 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
    if ${GREP} 'msgid=<123456789@local.dom>' ${PML} >/dev/null
    then
      M=`${GREP} 'msgid=<123456789@local.dom>' ${PML} | wc -l` 
      if test $M != 2
      then
        ERR=true
      fi

      if ${GREP} -i 'err' ${PML} >/dev/null
      then
        ERR=true
      fi
    else
      ERR=true
    fi
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi



# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
