#!/bin/sh
# $Id: mta-setup.sh,v 1.42 2005/08/01 21:44:48 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
# setup for the full system (to be sourced from other sh scripts)
# set some variables to their default values.
# create directories and files for proper operation.

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

#
W4S=12
W4C=12
export STE CLTL EDBR H

rm -f ${SRVL} ${CLTL}
#
# get full path to "checks" directory
MYDIR=`pwd`
cd ${SD} && CHKD=`pwd`
export CHKD
cd ${MYDIR}
if ${SM_CDQMGRDIR:-true}
then
  # cd to correct directory
  cd ../qmgr || exit 1
fi
umask 027

if ${SM_CLEANUP_DB:-false}
then
  # remove some leftovers that could screw up tests
  rm -f ${ALIMAP} ${QMGRCONFMAP} ${MTMAP}
fi
if ${SM_CLEANUP_MT:-false}
then
  # remove some leftovers that could screw up tests
  rm -f ${MTMAP}
fi

# initialize system? can be avoided by setting INIT to false
if ${INIT:-true}
then

  SMQUEUEDIRS="./"
  if test X"${LMTPDIR}" != "X"
  then
    test -d ${LMTPDIR} || mkdir ${LMTPDIR}
    SMQUEUEDIRS="${SMQUEUEDIRS} ${LMTPDIR}"
  fi
  if test X"${SMTPDIR}" != "X"
  then
    test -d ${SMTPDIR} || mkdir ${SMTPDIR}
    SMQUEUEDIRS="${SMQUEUEDIRS} ${SMTPDIR}"
  fi

  # create queue directories
  for i in 0 1 2 3 4 5 6 7 8 9 A B C D E F
  do
    for SMQUEUEDIR in ${SMQUEUEDIRS}
    do
      if test -d "${SMQUEUEDIR}"${i}
      then
        rm -f "${SMQUEUEDIR}"${i}/S00*
      else
        mkdir "${SMQUEUEDIR}"${i}
      fi
    done
  done

  # create directories for sockets
  for i in qmsmtps qmsmtpc qmsmar
  do
    test -d ${i} || mkdir ${i}
  done

  # create "mailertable"
  if test ! -f ${MT}
  then
     ${CAT} > ${MT} <<EOF
p.z	5
t.z	4
n.z	6
local.host	[127.0.0.1]
local.dom	lmtp:
b.c	[127.0.0.1]
y.z	[127.0.0.1]
x.z	[127.0.0.1]
t00.x.z	[127.0.0.1]
t01.x.z	[127.0.0.1]
t02.x.z	[127.0.0.1]
t03.x.z	[127.0.0.1]
t04.x.z	[127.0.0.1]
t05.x.z	[127.0.0.1]
t06.x.z	[127.0.0.1]
t07.x.z	[127.0.0.1]
t08.x.z	[127.0.0.1]
t09.x.z	[127.0.0.1]
t10.x.z	[127.0.0.1]
t11.x.z	[127.0.0.1]
t12.x.z	[127.0.0.1]
t13.x.z	[127.0.0.1]
t14.x.z	[127.0.0.1]
t15.x.z	[127.0.0.1]
t16.x.z	[127.0.0.1]
t17.x.z	[127.0.0.1]
x.y	[127.0.0.1]
t00.x.y	[127.0.0.1]
t01.x.y	[127.0.0.1]
t02.x.y	[127.0.0.1]
t03.x.y	[127.0.0.1]
t04.x.y	[127.0.0.1]
t05.x.y	[127.0.0.1]
t06.x.y	[127.0.0.1]
t07.x.y	[127.0.0.1]
t08.x.y	[127.0.0.1]
t09.x.y	[127.0.0.1]
t10.x.y	[127.0.0.1]
t11.x.y	[127.0.0.1]
t12.x.y	[127.0.0.1]
t13.x.y	[127.0.0.1]
t14.x.y	[127.0.0.1]
t15.x.y	[127.0.0.1]
t16.x.y	[127.0.0.1]
t17.x.y	[127.0.0.1]
m.x.y	[127.1.1.0] [127.0.0.1]
m2.x.y	[127.0.0.1] [127.1.1.0]
unreach.dom	[127.1.1.1]
EOF
  fi
fi

rm -f ${PIDS}
rm -f ${SMTPCSOCK}
rm -f ${SMARSOCK}
if ${RMIBDB:-true}
then
  test -d ${IBDBDIR} || mkdir -p ${IBDBDIR}
  rm -f ${IBDBDIR}/${IBDB}
fi
# clean out current DEFEDB...
if ${RMDEFEDB:-true}
then
  rm -rf ${DEFEDB}
  mkdir ${DEFEDB}
fi
