#!/bin/sh
# $Id: mcpmts.sh,v 1.17 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
# test program running the full system:
# mcp, qmgr, smar, smtpc, smtps
# using smtps and smtpc from statethreads/examples as source/sink
# this program tests some failure modes, e.g., temporary/permanent
# errors from the sink.
#
test -s stop && exit 1
#
# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
#
EDBOUT=edb.out
EDBROUT=edbr.out
EDBOK=edbr.ok
EDBOKIN=""
# default settings
TAS=1
THREADS=1
RCPTS=1
TOTAL=1
TR=1
TRQS=1
TTAS=-1
MULTIPLE=1
INIT=true
RMDEFEDB=true
SLEEP=9
RMIBDB=true
MCPPID=mcp.pid
SNDUSR1=false
SINK="smtps2"
MSACLTL=msasource.log
RCPTADDR=""
SENDER="-fa@b.c"
RCPT="-Rr@x.z"

# works only with ksh on OSF/1: how to test for it?
while getopts 13:A:B:c:E:Di:ILMm:Nn:O:o:R:rS:s:T:t:v:x:X:y:Y:Z: FLAG
do
  case "${FLAG}" in
    1)
       SNDUSR1=true;;
    3)
       # remove the socket
       rm -f ${OPTARG};
       LMTP="-L ${OPTARG}"
       LMTPSINK="unix:${OPTARG}";;
    A)
       TOTAL="${OPTARG}"
       ;;
    B)
       LMTPSINKOPTS="${OPTARG}"
       ;;
    c)
       SRCOPTS="${OPTARG}"
       ;;
    D) INIT=false;;
    E)
       TR="${OPTARG}"
       ;;
    I) RMIBDB=false;;
    L) SINKOPTS="${SINKOPTS} -L unix:lmtpsock";;
    m)
       MULTIPLE="${OPTARG}"
       ;;
    M) RMDEFEDB=false;;
    n)
       RCPTS="${OPTARG}"
       ;;
    N)
	SENDER=""
	RCPT=""
	;;
    o)
       OKDELAY="-o ${OPTARG}"
       ;;
    O)
	# expected results for t-edbr (DEFEDB)
       EDBOKIN="${OPTARG}"
       ;;
    R)
       RCPTADDR="${RCPTADDR} -R${OPTARG}"
       ;;
    r)
       SINK="smtps3"
       SMTPDIR="smtpdir/"
       SINKOPTS="-C ${SMTPDIR} ${SINKOPTS}"
       export SMTPDIR
       ;;
    s)
       SLEEP="${OPTARG}"
       ;;
    S)
       SENDER="-f${OPTARG}"
       ;;
    T)
       TAS="${OPTARG}"
       ;;
    t)
       THREADS="${OPTARG}"
       ;;
    x)
       TTAS="${OPTARG}"
       ;;
    X)
       TRQS="${OPTARG}"
       ;;
    Y)
       SINKOPTS="${SINKOPTS} ${OPTARG}"
       ;;
    Z)
       SOURCE="${OPTARG}"
       ;;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "$0: options:"
       echo "-1         send USR1 signal to all MTS components before shutdown"
       echo "-3 socket  also start LMTP sink (smtps3) listening on socket"
       echo "-A n       expected number of mails sent"
       echo "-B opts    use opts for smtps3 (requires -3 socket)"
       echo "-C opts    additional SMTP client options"
       echo "-c opts    additional options for source (sender) program"
       echo "-E n       expected number of recipients"
       #echo "-d n      debug level"
       echo "-D         do not initialize test environment"
       echo "-I         do not remove IBDB"
       echo "-i n       initial delay for retries in QMGR scheduler"
       echo "-m n       send n messages in separate sessions"
       echo "-M         do not remove defedb"
       echo "-n n       send n messages (source program)"
       echo "-N         do not pass sender or recipient address to source program"
       echo "-o n       after n seconds accept all mails in SMTP sink"
       echo "-O file    file contains expected results from t-edbr-0"
       echo "-Q opts    options for QMGR"
       echo "-R address recipient address"
       echo "-r         use SMTP sink smtps3"
       echo "-s n       sleep n seconds before terminating system"
       echo "-S address sender address"
       #echo "-T n      n transactions"
       #echo "-t n      n threads"
       echo "-v n       set loglevel to n"
       echo "-V opts    additional SMTP server options"
       echo "-X n       n requests are expected"
       echo "-Y opts    options for SMTP sink"
       echo "-Z source  source (sender) program"
       exit 1
       ;;
  esac
done
shift `expr ${OPTIND} - 1`

# configuration files must exist
test -f "${SMXCNF}" || exit 1
test -s "${MCPCNF}" || exit 1

#
# setup/initialize system
. ${SD}/mta-setup.sh
#
export SRVPORT P

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `${CAT} ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi
if test X"${SINKPID}" != "X"
then
  kill -TERM ${SINKPID}
fi
if test X"${LMTPPID}" != "X"
then
  kill -TERM ${LMTPPID}
fi
exit 1
}

SINKPID=""
LMTPPID=""
# store the PIDs for the started programs
rm -f ${PIDS}
trap killit 2 15

SRCPRG=${STE}/smtpc
if test X"${SOURCE}" != "X"
then
  SRCPRG=${STE}/${SOURCE}
fi

# start SMTP sink
${STE}/${SINK} ${PIPELINING} ${SINKOPTS} ${OKDELAY} -i -l . -b ${H}:${SNKPORT} > ${SRVL} 2>&1 &
status=$?
SINKPID=$!
if test "x${status}" != "x0"
then
  echo "$0: FAIL: cannot start server ${status}"
  exit ${status}
fi
sleep 1
export SINKPID SRVL

# start LMTP sink
if test X"${LMTPSINK}" != "X" -a X"${LMTPDIR}" != "X"
then
${STE}/smtps3 ${PIPELINING} -C ${LMTPDIR} -i -l . ${LMTPSINKOPTS} -L ${LMTPSINK} > ${LMTPL} 2>&1 &
status=$?
LMTPPID=$!
if test "x${status}" != "x0"
then
  echo "$0: FAIL: cannot start LMTP sink ${status}"
  exit ${status}
fi
sleep 1
fi

# path to programs
P=..

# go for it: start mcp
${P}/mcp/mcp -R 4 -p ${MCPPID} ${MCPCNF} > m.log 2>&1 &
echo $! >> ${PIDS}
#${CAT} ${MCPPID} >> ${PIDS}

#${CHKD}/qmgr-running.sh || killit
${CHKD}/mta-running.sh || killit
if test X"${MSAPORT}" != X
then
  ${CHKD}/mta-running.sh ${MSAPORT} || killit
fi

if test X"${SM_SOURCE}" != X
then
${SM_SOURCE}
else
if test X"${RCPTADDR}" != X
then
  if ${SRCPRG} ${SRCOPTS} -r ${H}:${SRVPORT} "${SENDER}" ${RCPTADDR} -n "${RCPTS}" -T "${TAS}" -t "${THREADS}" > ${CLTL} 2>&1
  then
    :
  else
    ${CAT} ${CLTL}
    ERRS=`expr ${ERRS} + 1 `
  fi

  if test X"${MSAPORT}" != X
  then
    if ${SRCPRG} ${SRCOPTS} -r ${H}:${MSAPORT} "${SENDER}" ${RCPTADDR} -n "${RCPTS}" -T "${TAS}" -t "${THREADS}" > ${MSACLTL} 2>&1
    then
      :
    else
      ${CAT} ${MSACLTL}
      ERRS=`expr ${ERRS} + 1 `
    fi
  fi

elif test ${MULTIPLE} -ge 2
then
  r=1
  while test ${r} -le ${MULTIPLE}
  do
  # send messages concurrently
    ${SRCPRG} ${SRCOPTS} -r ${H}:${SRVPORT} -fa-${r}@b.c -Rr-${r}@x.z -n "${RCPTS}" -T "${TAS}" -t "${THREADS}" > ${CLTL}-${r} 2>&1 &
    r=`expr ${r} + 1 `
  done
else
  # send message
  if ${SRCPRG} ${SRCOPTS} -r ${H}:${SRVPORT} ${SENDER} ${RCPT} -n "${RCPTS}" -T "${TAS}" -t "${THREADS}" > ${CLTL} 2>&1
  then
    :
  else
    ${CAT} ${CLTL}
    ERRS=`expr ${ERRS} + 1 `
  fi
fi
# SM_SOURCE 
fi

sleep ${SLEEP}

if ${SNDUSR1}
then
  for i in `${CAT} pids`
  do
    kill -USR1 ${i}
  done
fi

# ----------------
# stop MTA components
for i in `${CAT} pids`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall qmgr smar
fi

# send SMTP server a signal to dump its state
if kill -USR1 ${SINKPID}
then
  :
else
  echo "kill -USR1 failed: $?"
  exit 1
fi
sleep 2

# send LMTP server a signal to dump its state
if test X"${LMTPPID}" != "X"
then
  if kill -USR1 ${LMTPPID}
  then
    :
  else
    echo "kill -USR1 failed: $?"
    exit 1
  fi
  sleep 2
fi

# check state of SMTP server
if ${GREP} "^Address *${H}:${P}" ${SRVL} > /dev/null
then
  :
else
  echo "failed to listen on ${H}:${P}"
  ERRS=`expr ${ERRS} + 1 `
fi
if ${GREP} "^Thread.* 8/" ${SRVL} > /dev/null
then
  :
else
  echo "failed to start threads"
  ERRS=`expr ${ERRS} + 1 `
fi
# the number of requests can vary based on the scheduler...
RQS=`${GREP} "^Requests served *" ${SRVL} | head -1 | sed -e 's/^Requests served *//'`
if test "${RQS}" -lt "${TRQS}"
then
  echo "wrong number of requests: expected=${TRQS} got=${RQS} (-X)"
  ERRS=`expr ${ERRS} + 1 `
fi
if egrep "^Recipients accepted * ${TR}$" ${SRVL} > /dev/null
then
  :
else
  echo "wrong number of recipients: expected=${TR} (-E)"
  ${GREP} "^Recipients" ${SRVL}
  ERRS=`expr ${ERRS} + 1 `
fi

# check SMTP client (source)
if test ${MULTIPLE} -ge 2
then
  r=1
  msgs=0
  while test ${r} -le ${MULTIPLE}
  do
    SENT=`${GREP} "total=" ${CLTL}-${r} | sed -e 's/^.*total=\([0-9]*\) .*/\1/'`
    msgs=`expr ${SENT} + ${msgs}`
    r=`expr ${r} + 1 `
  done
  if test ${TOTAL} = ${msgs}
  then
    :
  else
    echo "wrong number of mails sent: expected=${TOTAL}, got=${msgs} (-A)"
    ERRS=`expr ${ERRS} + 1 `
  fi

  if test ${TTAS} -ge 0
  then
    # the number of transactions can vary based on the scheduler...
    TASS=`${GREP} "^Transactions *" ${SRVL} | sed -e 's/^Transactions *//'`
    if test "${TASS}" -lt "${TTAS}"
    then
      echo "wrong number of transactions: expected=${TTAS} got=${TASS}"
      ERRS=`expr ${ERRS} + 1 `
    fi
  fi

else
if ${GREP} "total=${TOTAL} " ${CLTL} > /dev/null
then
  :
else
  echo "wrong number of mails sent: expected=${TOTAL}"
  ${GREP} "total=" ${CLTL}
  ERRS=`expr ${ERRS} + 1 `
fi
fi

# ----------------
kill -TERM ${SINKPID}
if test X"${LMTPPID}" != "X"
then
  kill -TERM ${LMTPPID}
fi

# ----------------
if ${IDBR0} >/dev/null
then
  if test "${ERRS}" = "0"
  then
    rm -f ibdd/ibd00000000*
  fi
else
  echo "t-idbr-0 failed"
  ERRS=`expr ${ERRS} + 1 `
fi

if test X"${EDBOKIN}" != X
then
if ${EDBR} > ${EDBROUT} 2>&1
then
  if egrep -v 'tests completed successfully|time|(id|cdb|srv_ip4)=' ${EDBROUT} > ${EDBOUT} 2>&1
  then
    if diff ${EDBOUT} ${EDBOKIN}
    then
      :
    else
      ERRS=`expr ${ERRS} + 1 `
    fi
  fi
else
  echo "${EDBR} failed"
  ERRS=`expr ${ERRS} + 1 `
fi
fi

# ----------------
for i in smtps smtpc qmgr smar MTA MSA
do
  if test -s ${i}.log
  then
    if egrep "${ERRORPAT}" ${i}.log
    then
      ERRS=`expr ${ERRS} + 1 `
    fi
  fi
done

# ----------------
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
