/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-stdio-5.c,v 1.4 2004/12/29 23:47:29 ca Exp $")
#include "sm/io.h"
#include "sm/test.h"
#include <stdio.h>

#define SM_N_CHARS	(65536 * 1)
#define SM_STEP		255
#define SM_FN		"foo"

static void
testputc(sm_file_T *fp, int off, int st)
{
	int i;
	uchar c, r;
	sm_ret_T res;

	res = sm_io_seek(fp, (long) off, SM_IO_SEEK_SET);
	SM_TEST(res == SM_SUCCESS);
	for (i = off; i < SM_N_CHARS; i++)
	{
		c = (uchar) (i + st);
		r = sm_putc(fp, c);
		SM_TEST(c == r);
	}
}

static void
testgetc(sm_file_T *fp, int off, int st)
{
	int i;
	uchar c, r;
	sm_ret_T res;

	res = sm_io_seek(fp, (long) off, SM_IO_SEEK_SET);
	SM_TEST(res == SM_SUCCESS);
	for (i = off; i < SM_N_CHARS; i++)
	{
		c = (uchar) (i + st);
		r = sm_getc(fp);
		SM_TEST(c == r);
	}
}

int
main(int argc, char *argv[])
{
	sm_ret_T res;
	sm_file_T *fp;

	sm_test_begin(argc, argv, "test sm_io_putc");
	res = sm_io_open(SmStStdio, SM_FN, SM_IO_RDWR, &fp, SM_IO_WHAT_END);
	SM_TEST(res == SM_SUCCESS);
	SM_TEST(fp != NULL);
	if (fp != NULL)
	{
		int off;

		for (off = 0; off < SM_N_CHARS; off += SM_STEP)
		{
			testputc(fp, off, off / 2);
			testgetc(fp, off, off / 2);
		}
		res = sm_io_close(fp);
		SM_TEST(res == SM_SUCCESS);
		unlink(SM_FN);
	}
	return sm_test_end();
}
