#!/bin/sh
# $Id: t-sr-msg.sh,v 1.7 2005/05/06 22:20:08 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
# test passing messages between two programs (sendmsg/recvmsg)
#
test -s stop && exit 1
#
SRV="error.srv"
CLT="error.clt"
SOCK="rdwrfd"
VERBOSE=""
# message passing with system I/O
P1="./t-sr-msg"
# message passing with statethreads
P2="./t-sr-msg-st"

test -x ${P1} || exit 1
test -x ${P2} || exit 1

while getopts V FLAG
do
  case "${FLAG}" in
    V) VERBOSE="${VERBOSE} -V";;
  esac
done

# programs to test
PRGS="${P1} ${P2}"
#

for S in ${PRGS}
do
  for C in ${PRGS}
  do
    rm -f ${SRV} ${CLT} ${SOCK}
    ${S} -s ${VERBOSE} > ${SRV} &
    sleep 1
    ${C} -c ${VERBOSE} 2> ${CLT}
    wait
    sleep 2
  done
done

exit 0
