/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rcbst.c,v 1.15 2005/05/31 21:00:28 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"
#include "sm/memops.h"
#include "sm/io.h"
#include "sm/ctype.h"
#include "sm/fcntl.h"
#include "sm/rcbst.h"
#include "sm/unixsock.h"
#include "statethreads/st.h"
#include "sm/check.h"
#include "sm/stsock.h"
#include "t-rcb.h"

#include <stdio.h>

extern char *optarg;
extern int optind;
extern int optopt;
extern int opterr;

int Verbose;

#define SEC2USEC(s) ((s)*1000000LL)
static st_utime_t tmo = SEC2USEC(5);

void
usage(const char *prg)
{
	fprintf(stderr, "usage: %s [options] socket\n", prg);
	exit(0);
}

/* dirty hack ahead: specify timeout for function call */
#define TMO  , tmo
#include "t-rcb-sr.c"

/*
**  USTRCBCLIENT -- send rcb
**
**	Parameters:
**		sockname -- name of socket
**		clientonly -- act only as client
**
**	Returns:
**		none
*/

void
ustrcbclient(char *sockname, bool clientonly, uint rcbsize, uint maxrcbsize, uint elems, uint32_t rt, st_utime_t writetmo)
{
	st_netfd_t fd;
	sm_rcb_P rcb;
	sm_ret_T ret;

	if (Verbose > 1)
		fprintf(stderr, "clt: connect\n");
	rcb = NULL;
	fd = NULL;
	ret = un_st_client_connect(sockname, tmo, &fd);
	if (Verbose > 1)
		fprintf(stderr, "clt: connected=%lx, ret=%x, errno=%d\n",
			(long) fd, ret, errno);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return;
	SM_TEST(fd != NULL);
	if (fd == NULL)
		return;

	rcb = sm_rcb_new(NULL, rcbsize, maxrcbsize);
	SM_TEST(rcb != NULL);
	if (rcb == NULL)
		goto done;

	if (elems > 0)
	{
		fillrcb(rcb, elems, rt);
		if (writetmo > 0)
			tmo = writetmo;
		writercb(rcb, fd);
	}
	else
	{
		do
		{
			ret = sendrcb(rcb, fd);
			if (sm_is_err(ret))
				break;
			if (!clientonly)
				ret = rcvrcb(rcb, fd, true);
		} while (!sm_is_err(ret));
	}

  done:
	if (rcb != NULL)
		sm_rcb_free(rcb);
	un_st_socket_close(fd);
}

int
main(int argc, char *argv[])
{
	int c;
	bool clientonly;
	uint elems, rcbsize, maxrcbsize;
	uint32_t rt;
	st_utime_t writetmo;
	char *sockname, *prg;

	opterr = 0;
	Verbose = 0;
	sockname = NULL;
	clientonly = false;
	elems = 0;
	rt = 0;
	rcbsize = SM_RCBSIZE;
	maxrcbsize = SM_MAXRCBSIZE;
	writetmo = 0;
	prg = argv[0];
	while ((c = getopt(argc, argv, "ce:m:r:s:w:V")) != -1)
	{
		switch (c)
		{
		  case 'c':
			clientonly = true;
			break;
		  case 'e':
			elems = atoi(optarg);
			break;
		  case 'm':
			maxrcbsize = atoi(optarg);
			break;
		  case 'r':
			rt = atoi(optarg);
			break;
		  case 's':
			rcbsize = atoi(optarg);
			break;
		  case 'w':
			writetmo = SEC2USEC(atoi(optarg));
			break;
		  case 'V':
			++Verbose;
			break;
		  default:
			usage(prg);
		}
	}
	sm_test_begin(argc, argv, "unix statethreads rcb client");
	argc -= optind;
	argv += optind;
	if (argc <= 0)
		usage(prg);
	sockname = argv[0];
	c = st_init();
	SM_TEST(c >= 0);
	if (c < 0)
		exit(1);
	ustrcbclient(sockname, clientonly, rcbsize, maxrcbsize, elems, rt
		, writetmo);
	return sm_test_end();
}
