/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: log.h,v 1.9 2005/06/16 00:39:10 ca Exp $
 */

#ifndef SMTPS_LOG_H
#define SMTPS_LOG_H 1

#include "sm/generic.h"
#include "sm/log.h"

#if SMTPS_LOG_DEFINES
sm_logcategory_T ss_lcats[] =
{
	{ "init",	0 },
	{ "config",	0 },
	{ "server",	0 },
	{ "comm",	0 },
	{ NULL,		0 }
};

sm_logmodule_T ss_lmods[] =
{
	{ "smtps/to_qmgr",	0 },
	{ "smtps/from_qmgr",	0 },
	{ "smtps/config",	0 },
	{ "smtps/server",	0 },
	{ "smtps/comm",		0 },
	{ NULL,			0 }
};

#else /* SMTPS_LOG_DEFINES */

/* should these be global or per ss context? */
extern sm_logcategory_T ss_lcats[];
extern sm_logmodule_T ss_lmods[];

#endif /* SMTPS_LOG_DEFINES */

#define SS_LCAT_INIT	(&ss_lcats[0])
#define SS_LCAT_CONFIG	(&ss_lcats[1])
#define SS_LCAT_SERVER	(&ss_lcats[2])
#define SS_LCAT_COMM	(&ss_lcats[3])

/* Backwards compatibility. */
#define SS_LCAT_GENERAL	SM_LOGCATEGORY_GENERAL

#define SS_LMOD_TO_QMGR		(&ss_lmods[0])
#define SS_LMOD_FROM_QMGR	(&ss_lmods[1])
#define SS_LMOD_CONFIG		(&ss_lmods[2])
#define SS_LMOD_SERVER		(&ss_lmods[3])
#define SS_LMOD_COMM		(&ss_lmods[4])

void	 ss_log_init(sm_log_ctx_P _lctx);
void	 ss_log_setcontext(sm_log_ctx_P _lctx);

#endif /* SMTPS_LOG_H */
