#!/bin/sh
# $Id: t-alias-0.sh,v 1.21 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses.
# Uses smar, t-smar-1, "aliases" map, t-mm, startsmar.sh
# and t-hostname
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=alias-0.out
RES=alias-0.ip
OK=alias-0.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# Note: reference to t-hostname! XREF
HOSTNAME=`../libmta/t-hostname -l -V 2>/dev/null`
if test $? -ne 0
then
  echo "t-hostname failed"
  exit 1
fi
if test X"${HOSTNAME}" = X
then
  echo "t-hostname returned empty name"
  exit 1
fi
if echo X"${HOSTNAME}" | grep '\.' >/dev/null
then
  :
else
  echo "t-hostname returned bogus name ${HOSTNAME}"
  exit 1
fi

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

# create map for smar
rm -f ${ALIMAP}
${MM} <<EOF
user:	local:
user+*:	<user@local.dom>
user++:	local:
postmaster:	<user+postmaster@local.dom>
loc:	user
nodetail:	<user2@local.dom>
EOF
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
${HOSTNAME}	lmtp:
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${RES} ${OK}

TEST=1
# ----------------------------------------
# check output somehow...
${VALGRIND} ${TPRG} -VVV '<no@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} > ${RES}
cat > ${OK} <<EOF
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff -i ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<user@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} > ${RES}
cat > ${OK} <<EOF
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff -i ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<user+det@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} > ${RES}
cat > ${OK} <<EOF
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff -i ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<postmaster@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliased=<user+postmaster@local.dom>
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff -i ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=5
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<user+@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliased=<user@local.dom>
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff -i ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=6
# ----------------------------------------
${VALGRIND} ${TPRG} -M -VVV '<loc@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliased=<user@${HOSTNAME}>
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff -i ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=7
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<nodetail@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliased=<user2@local.dom>
IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]
EOF
if diff -i ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

#${TPRG} -VVV '<ok@local.dom>' '<postmaster@local.dom>' > ${OUT} 2>&1
#egrep '^(IP|alias)' ${OUT} > ${RES}
#cat > ${OK} <<EOF
#status=0
#status=0
#EOF
#if diff -i ${OK} ${RES}
#then
#  :
#else
#  ERRS=`expr ${ERRS} + 1 `
#  echo "$0: test ${TEST} failed."
#  test X"${SM_STOPONERROR}" != X && killit
#fi

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
rm -f ${MTMAP}

exit ${ERRS}
