/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: thrlock.c,v 1.2 2004/08/27 18:09:19 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/pthread.h"
#include "sm/io.h"

#if SM_DEBUG_MUTEX
int
sm_thread_mutex_lock(pthread_mutex_t *mutex, const char *mname, const char *fct)
{
	int r;

	sm_io_fprintf(smioerr, "%s: trying to lock %s\n", fct, mname);
	r = pthread_mutex_lock(mutex);
	sm_io_fprintf(smioerr, "%s: locked %s\n", fct, mname);
	return r;
}

int
sm_thread_mutex_unlock(pthread_mutex_t *mutex, const char *mname, const char *fct)
{
	sm_io_fprintf(smioerr, "%s: unlocking %s\n", fct, mname);
	return pthread_mutex_unlock(mutex);
}
#endif /* SM_DEBUG_MUTEX */
