/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: thread.c,v 1.6 2005/01/27 00:29:19 ca Exp $")
#include "sm/error.h"
#include "sm/pthread.h"

/*
**  THR_INIT -- initialize thread system
**
**	Parameters:
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
thr_init(void)
{
#if HAVE_PTHREAD_SETCONCURRENCY
	int r;

	/* XXX set this depending on the number of CPUs */
	r = pthread_setconcurrency(2);
	if (r != 0)
		return sm_error_perm(SM_EM_THR, r);
#endif /* HAVE_PTHREAD_SETCONCURRENCY */
	return SM_SUCCESS;
}

/*
**  THR_STOP -- stop thread system
**
**	Parameters:
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
thr_stop(void)
{
	return SM_SUCCESS;
}
