/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-passwd-0.c,v 1.8 2005/01/27 00:29:19 ca Exp $")

#include "sm/error.h"
#include "sm/heap.h"
#include "sm/memops.h"
#include "sm/test.h"
#include "sm/maps.h"
#include "sm/mapc.h"
#include "sm/map.h"
#include "sm/mapclasses.h"

#include "sm/io.h"

int Verbose = 0;

#define MAPC_TYPE	"passwd"
#define MAPC_NAME	"passwd"
#define SM_ADDR_DELIM	((uchar) '+')

static void
testh(void)
{
	sm_ret_T ret;
	sm_maps_P maps;
	sm_map_P map;
	sm_cstr_P mtype, mname;
	sm_str_P lhs, rhs;

	maps = NULL;
	mtype = mname = NULL;
	lhs = rhs = NULL;

	ret = sm_maps_init(&maps);
	SM_TEST(maps != NULL);
	if (maps == NULL)
		return;
	SM_TEST(sm_is_success(ret));

	mtype = sm_cstr_scpyn0((const uchar *)MAPC_TYPE, strlen(MAPC_TYPE));
	SM_TEST(mtype != NULL);
	if (mtype == NULL)
		goto error;

	mname = sm_cstr_scpyn0((const uchar *)MAPC_NAME, strlen(MAPC_NAME));
	SM_TEST(mname != NULL);
	if (mname == NULL)
		goto error;

	lhs = sm_str_new(NULL, 256, 1024);
	SM_TEST(lhs != NULL);
	if (lhs == NULL)
		goto error;

	rhs = sm_str_new(NULL, 256, 1024);
	SM_TEST(rhs != NULL);
	if (rhs == NULL)
		goto error;

	ret = sm_passwd_class_create(maps);
	SM_TEST(sm_is_success(ret));

	map = NULL;
	ret = sm_map_open(maps, mname, mtype, 0, NULL, SMAP_MODE_RDWR, &map,
			SMPO_END);
	SM_TEST(sm_is_success(ret));
	if (!sm_is_success(ret))
		goto error;

	/* lookup root (should exist) */
	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"root");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(sm_is_success(ret));

	ret = sm_map_lookup_addr(map, lhs, NULL, /* domain */ NULL,
		/* tag */ NULL, SM_ADDR_DELIM, SMMAP_LFL_ALIAS, rhs);
	SM_TEST(sm_is_success(ret));

	/* lookup "bogus:user" (should not exist) */
	sm_str_clr(rhs);
	sm_str_clr(lhs);
	sm_str_scat(lhs, (const char *)"bogus:user");
	ret = sm_map_lookup(map, SMMAP_FL_NONE, lhs, rhs);
	SM_TEST(!sm_is_success(ret));

	ret = sm_map_lookup_addr(map, lhs, NULL, /* domain */ NULL,
		/* tag */ NULL, SM_ADDR_DELIM, SMMAP_LFL_ALIAS, rhs);
	SM_TEST(!sm_is_success(ret));

	ret = sm_map_close(map, 0);
	SM_TEST(sm_is_success(ret));

	ret = sm_maps_term(maps);
	SM_TEST(sm_is_success(ret));
	SM_CSTR_FREE(mtype);
	SM_CSTR_FREE(mname);
	SM_STR_FREE(lhs);
	SM_STR_FREE(rhs);
	return;

  error:
	sm_maps_term(maps);
}


int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "H:s:V")) != -1)
	{
		switch (c)
		{
		  default:
			return 1;
		}
	}
	sm_test_begin(argc, argv, "test passwd map 0");
	testh();
	return sm_test_end();
}
