/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_setreply.c,v 1.2 2005/08/29 20:19:30 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/ctype.h"
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"

#if SM_USE_PMILTER

/*
**  SM_PMFI_SETREPLY -- Set reply for next command
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		reply -- reply text including error codes
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmfi_setreply(pmse_ctx_P pmse_ctx, const char *reply)
{
	sm_ret_T ret;

	SM_IS_PMSE_CTX(pmse_ctx);
	if (reply != NULL && *reply != '\0')
	{
		size_t len;
		char c;

		len = strlen(reply);
		if (len < 5)
			return sm_err_perm(EINVAL);
		c = reply[0];
		if (c != '2' && c != '3' && c != '4' && c != '5')
			return sm_err_perm(EINVAL);
		if (!ISDIGIT(reply[1]) || !ISDIGIT(reply[2]))
			return sm_err_perm(EINVAL);
		if (reply[len - 2] != '\r' || reply[len - 1] != '\n')
			return sm_err_perm(EINVAL);
		ret = sm_str_scopy(pmse_ctx->pmse_reply, reply);
	}
	else
	{
		sm_str_clr(pmse_ctx->pmse_reply);
		ret = SM_SUCCESS;
	}
	return ret;
}
#endif /* SM_USE_PMILTER */
