#!/bin/sh
# $Id: t-extracthdr-0.sh,v 1.2 2005/09/01 17:14:04 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
#
IN=t_extracthdr.in
OK=t_extracthdr.ok
OUT=t_extracthdr.out
ERR=t_extracthdr.err
ERRORS=0
PRG=./t-extracthdr

TEST=0
for S in 0 1 2 4 8 10 100
do
cat > ${IN} <<EOF
From: someone@some.com
To: luser@victim.com
SUBJECT: M$
  sucks
MIME-Version: 1.0
Content-Type: multipart/alternative; boundary="abcdef"

oh really?
EOF

TEST=`expr ${TEST} + 1 `
${PRG} -s $S ${IN} > ${OUT} 2> ${ERR}

cat > ${OK} <<EOF
name: From
value: someone@some.com
name: To
value: luser@victim.com
name: SUBJECT
value: M$%0D%0A  sucks
name: MIME-Version
value: 1.0
name: Content-Type
value: multipart/alternative; boundary="abcdef"
EOF

diff ${OUT} ${OK}
if test $? -ne 0
then
  echo "$0: ${TEST} -s $S failed"
  ERRORS=`expr ${ERRORS} + 1 `
fi

cat > ${IN} <<EOF
From: Someone@Some.com
To: luser@victim.com
Subject: M$
 
  sucks
Content-Type: multipart/alternative;
  boundary="abcdef"
MIME-Version: 1.0

oh yeah?
EOF

TEST=`expr ${TEST} + 1 `
${PRG} -s $S ${IN} > ${OUT} 2> ${ERR}

cat > ${OK} <<EOF
name: From
value: Someone@Some.com
name: To
value: luser@victim.com
name: Subject
value: M$%0D%0A %0D%0A  sucks
name: Content-Type
value: multipart/alternative;%0D%0A  boundary="abcdef"
name: MIME-Version
value: 1.0
EOF

diff ${OUT} ${OK}
if test $? -ne 0
then
  echo "$0: ${TEST} -s $S failed"
  ERRORS=`expr ${ERRORS} + 1 `
fi

done


if test ${ERRORS} -eq 0
then
  rm -f ${IN} ${OK} ${OUT} ${ERR}
fi

exit ${ERRORS}
