/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strshift.c,v 1.3 2005/06/09 00:43:40 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/ctype.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_SHIFT -- shift str by some positions
**
**	Parameters:
**		str -- string
**		off -- number of positions to shift to the left
**
**	Returns:
**		usual error code
*/

sm_ret_T
sm_str_shift(sm_str_P str, uint off)
{
	uint i, len;

	SM_IS_BUF(str);

	len = sm_str_getlen(str);
	if (len <= off)
		return sm_error_perm(SM_EM_STR, EINVAL);

	for (i = 0; i < len - off; i++)
		sm_str_wr_elem(str, i, sm_str_rd_elem(str, i + off));
	sm_str_wr_elem(str, len - off, '\0');
	SM_STR_SETLEN(str, len - off);
	return SM_SUCCESS;
}
