/*
 * Copyright (c) 2000-2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strget.c,v 1.14 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_GETDATA -- Return pointer to data buffer _inside_ str.
**
**	This returns a pointer to the '\0' terminated data buffer
**	inside of sm_str_P object str.
**	This is dynamic data, and is not guaranteed to be the same
**	after subsequent calls to other sm_str_* functions.
**
**	Parameters:
**		str -- sm_str_P object.
**
**	Returns:
**		'\0 terminated buf data embedded in str.
**		NULL on error.
*/

uchar *
sm_str_getdata(sm_str_P str)
{
	SM_IS_BUF(str);
	if ((str->sm_str_len > 0 &&
	     str->sm_str_base[str->sm_str_len - 1] == '\0') ||
	    (str->sm_str_size > str->sm_str_len &&
	     str->sm_str_base[str->sm_str_len] == '\0'))
		return str->sm_str_base;
	if (str->sm_str_len == str->sm_str_size)
	{
		uint new_alloc;

		/* We need room for the final '\0' */
		new_alloc = str->sm_str_len + 1;
		SM_STR_INCREASE_N_R(str, new_alloc);
	}
	str->sm_str_base[str->sm_str_len] = '\0';
	return str->sm_str_base;
}
